<?php

/**
 * @package Dotclear
 * @subpackage Core
 *
 * @copyright Olivier Meunier & Association Dotclear
 * @copyright AGPL-3.0
 */
declare(strict_types=1);

namespace Dotclear\Interface\Core;

use Dotclear\Database\Structure;
use Dotclear\Helper\Container\ContainerInterface;
use Dotclear\Interface\Database\ConnectionInterface;

/**
 * @brief   Database handler interface.
 *
 * @since   2.36
 */
interface DatabaseInterface extends ContainerInterface
{
    /**
     * Get dabatase connection handler instance.
     *
     * This connection instance uses parameters from config service.
     *
     * @throws  \Dotclear\Exception\DatabaseException
     */
    public function con(): ConnectionInterface;

    /**
     * Get new dabatase connection handler instance.
     *
     * @throws  \Dotclear\Exception\DatabaseException
     *
     * @param   string  $driver         Driver name
     * @param   string  $host           Database hostname
     * @param   string  $database       Database name
     * @param   string  $user           User ID
     * @param   string  $password       Password
     * @param   bool    $persistent     Persistent connection
     * @param   string  $prefix         Database tables prefix
     */
    public function newCon(string $driver, string $host, string $database, string $user = '', string $password = '', bool $persistent = false, string $prefix = ''): ConnectionInterface;

    /**
     * Get database structure handler.
     *
     * The handler uses current connexion.
     * Each call to this method MUST return a new instance.
     *
     * @return  Structure   The database structure handler
     */
    public function structure(): Structure;

    /**
     * Get combo of available database drivers.
     *
     * @throws  \Dotclear\Exception\DatabaseException
     *
     * @return  array<string, string>   The drivers name/driver pairs
     */
    public function combo(): array;
}
