<?php
/**
 * @package     Dotclear
 *
 * @copyright   Olivier Meunier & Association Dotclear
 * @copyright   AGPL-3.0
 */
declare(strict_types=1);

namespace Dotclear\Plugin\antispam;

/**
 * @brief   The module REST service handler.
 * @ingroup antispam
 */
class Rest
{
    /**
     * Gets the spams count. (JSON)
     *
     * @return  array<string, mixed>   The spams count message
     */
    public static function getSpamsCount(): array
    {
        $count = Antispam::countSpam();
        if ($count > 0) {
            $str = sprintf(($count > 1) ? __('(including %d spam comments)') : __('(including %d spam comment)'), $count);
        } else {
            $str = '';
        }

        return [
            'ret' => $str,
        ];
    }
}
