# README

[![Crowdin](https://badges.crowdin.net/e/d5f0441bf4f73af0177d34047b5b8482/localized.svg)](https://dotclear.crowdin.com/dotclear)

## WHAT IS DOTCLEAR

Dotclear is an open-source web publishing software.
Take control over your blog!

Dotclear project's purpose is to provide a user-friendly
tool allowing anyone to publish on the web, regardless of their technical skills.

### Features

- Easy publication
- Fully customizable theme
- User-friendly administration
- Flexible template system
- Media management
- Choose from several editing syntax (wiki, markdown or directly in wysiwyg)
- Flexible comment system
- Built-in antispam
- Localization
- Presentation widgets
- Themes and plugins
- Pages
- Tags and categories
- Automated installation
- Support for several database types
- Multiblog
- Multi-user with permissions
- Standards compliant
- Accessible
- Importing / exporting
- Naturally optimized for search engines
- Syndication feeds
- Complete trackback/pingback/webmention support
- Full Unicode support
- Extensible
- Performance and scalability
- Twice free

## REQUIREMENTS

In order to run Dotclear you need:

- A web server (Apache, Nginx, lighttpd, Caddy, etc)
- PHP 8.1 to 8.3 with the following modules:
  - mbstring
  - iconv
  - simplexml
  - mysqli, postgresql or sqlite
  - intl (required for PHP 8.2+)
- A database server (MySQL/MariaDB or PostgreSQL) or SQLite.

## INSTALLATION

### Automatic installation

The easiest way to install the blog engine is automatic installation.
Download the [one minute install file][1], upload it to your web space. Then open it in your favorite browser. You'll only have to follow the instructions on screen. See the [documentation][2] for more information.

### Standard installation

You need to download [Dotclear archive][3], extract it then upload your files to your web space using an FTP client.
Then open your favorite browser and go to <https://your.host.name/dotclear/admin/install/>. A message alerts you that you haven't got a configuration file and offers to run the wizard. Click this link.

## DOCUMENTATION

Still unsure if you want to move? A "[guided tour][4]" is what you need.

Dotclear is fully documented:

- If you have moved in already, the [User Manual][5] is there for you.
- The managers will turn to the [Administration Guide][6].
- Decorators and craftsmen will surely enjoy reading the [Developer and designer resources][7].

Dotclear documentation uses a wiki. Feel free to contribute.

## License

Copyright Olivier Meunier & Association Dotclear

AGPL-v3 <https://www.gnu.org/licenses/agpl-3.0.html>

This program is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with this program.  If not, see <https://www.gnu.org/licenses/>.

## CONTRIBUTING

Dotclear is an open source project. If you'd like to contribute, please read the [CONTRIBUTING file](/CONTRIBUTING.md).
You can submit a pull request, or feel free to use any other way you'd prefer.

### Repositories

<https://git.dotclear.org/dotclear/> (official)
<https://github.com/dotclear/dotclear> (Github mirror)

<https://dotclear.crowdin.com/dotclear> (online translations)

---

[1]: https://download.dotclear.org/loader/dotclear-loader.php
[2]: https://dotclear.org/documentation/2.0/admin/install
[3]: https://dotclear.org/download
[4]: https://dotclear.org/documentation/2.0/overview/tour
[5]: https://dotclear.org/documentation/2.0/usage
[6]: https://dotclear.org/documentation/2.0/admin
[7]: https://dotclear.org/documentation/2.0/resources
