<?php
/**
 * @brief pings, a plugin for Dotclear 2
 *
 * @package Dotclear
 * @subpackage Plugins
 *
 * @copyright Olivier Meunier & Association Dotclear
 * @copyright GPL-2.0-only
 */
if (!defined('DC_CONTEXT_ADMIN')) {
    return;
}

$_menu['Blog']->addItem(
    __('Pings'),
    $core->adminurl->get('admin.plugin.pings'),
    [dcPage::getPF('pings/icon.svg'), dcPage::getPF('pings/icon-dark.svg')],
    preg_match('/' . preg_quote($core->adminurl->get('admin.plugin.pings')) . '/', $_SERVER['REQUEST_URI']),
    $core->auth->isSuperAdmin()
);

$__autoload['pingsAdminBehaviors'] = __DIR__ . '/lib.pings.php';

$core->addBehavior('adminPostHeaders', ['pingsAdminBehaviors', 'pingJS']);
$core->addBehavior('adminPostFormItems', ['pingsAdminBehaviors', 'pingsFormItems']);
$core->addBehavior('adminAfterPostCreate', ['pingsAdminBehaviors', 'doPings']);
$core->addBehavior('adminAfterPostUpdate', ['pingsAdminBehaviors', 'doPings']);

$core->addBehavior(
    'adminDashboardFavorites',
    function ($core, $favs) {
        $favs->register('pings', [
            'title'      => __('Pings'),
            'url'        => $core->adminurl->get('admin.plugin.pings'),
            'small-icon' => [dcPage::getPF('pings/icon.svg'), dcPage::getPF('pings/icon-dark.svg')],
            'large-icon' => [dcPage::getPF('pings/icon.svg'), dcPage::getPF('pings/icon-dark.svg')],
        ]);
    }
);

$core->addBehavior('adminPageHelpBlock', function ($blocks) {
    $found = false;
    foreach ($blocks as $block) {
        if ($block == 'core_post') {
            $found = true;

            break;
        }
    }
    if (!$found) {
        return;
    }
    $blocks[] = 'pings_post';
});
