<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Dotclear 2.
#
# Copyright (c) 2003-2008 Sacha and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::checkSuper();

if (!is_readable(DC_DIGESTS)) {
	dcPage::open(__('Dotclear update'));
	echo '<h2>Access denied</h2>';
	dcPage::close();
	exit;
}

# Hide "update me" message
if (!empty($_GET['hide_msg'])) {
	dcUpdate::hideNotifications();
	http::redirect('index.php');
}

$p_url = 'update.php';

$step = isset($_GET['step']) ? $_GET['step'] : '';
$step = in_array($step,array('check','download','backup','unzip')) ? $step : '';

$new_v = dcUpdate::check();

$archives = array();
foreach (files::scanDir(DC_ROOT) as $v) {
	if (preg_match('/backup-([0-9A-Za-z\.-]+).zip/',$v)) {
		$archives[] = $v;
	}
}

# Revert or delete backup file
if (!empty($_POST['backup_file']) && in_array($_POST['backup_file'],$archives))
{
	$b_file = $_POST['backup_file'];
	
	try
	{
		if (!empty($_POST['b_del']))
		{
			if (!@unlink(DC_ROOT.'/'.$b_file)) {
				throw new Exception(sprintf(__('Unable to delete file %s'),html::escapeHTML($b_file)));
			}
			http::redirect($p_url);
		}
		
		if (!empty($_POST['b_revert']))
		{
			$zip = new fileUnzip(DC_ROOT.'/'.$b_file);
			$zip->unzipAll(DC_ROOT.'/');
			@unlink(DC_ROOT.'/'.$b_file);
			http::redirect($p_url);
		}
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

# Upgrade process
if (!empty($new_v) && $step)
{
	try
	{
		switch ($step)
		{
			case 'check':
				dcUpdate::checkIntegrity();
				http::redirect($p_url.'?step=download');
				break;
			case 'download':
				dcUpdate::download($new_v);
				http::redirect($p_url.'?step=backup');
				break;
			case 'backup':
				dcUpdate::backup($new_v);
				http::redirect($p_url.'?step=unzip');
				break;
			case 'unzip':
				if (!dcUpdate::checkDownload($new_v)) {
					throw new Exception(
						sprintf(__('Downloaded Dotclear archive seems to be corrupted. '.
						'Try <a %s>download it</a> again.'),'href="'.$p_url.'?step=download"')
					);
				}
				
				dcUpdate::performUpgrade($new_v);
				break;
		}
	}
	catch (Exception $e)
	{
		$msg = $e->getMessage();
		if (isset($e->bad_files))
		{
			$msg .=
			'<ul><li><strong>'.
			implode('</strong></li><li><strong>',$e->bad_files).
			'</strong></li></ul>';
		}
		
		$core->error->add($msg);
	}
}

/* DISPLAY Main page
-------------------------------------------------------- */
dcPage::open(__('Dotclear update'));

if (!$core->error->flag()) {
	echo '<h2>'.__('Dotclear update').'</h2>';
}

if (!$step)
{
	if (empty($new_v))
	{
		echo '<p><strong>'.__('No newer Dotclear version available.').'</strong></p>';
	}
	else
	{
		echo
		'<p class="static-msg">'.sprintf(__('Dotclear %s is available.'),$new_v).'</p>'.
		
		'<p>'.__('To upgrade your Dotclear installation simply click on the following button. '.
			'A backup file of your current installation will be created in your root directory.').'</p>'.
		'<form action="'.$p_url.'" method="get">'.
		'<p><input type="hidden" name="step" value="check" />'.
		'<input type="submit" value="'.__('Update Dotclear').'" /></p>'.
		'</form>';
	}
	
	if (!empty($archives))
	{
		echo
		'<h3>'.__('Update backup files').'</h3>'.
		'<p>'.__('The following files are backups of previously updates. '.
		'You can revert your previous installation or delete theses files.').'</p>';
		
		echo	'<form action="'.$p_url.'" method="post">';
		
		foreach ($archives as $v) {
			echo
			'<p><label class="classic">'.form::radio(array('backup_file'),html::escapeHTML($v)).' '.
			html::escapeHTML($v).'</label></p>';
		}
		
		echo
		'<p><strong>'.__('Please note that reverting your Dotclear version may have some '.
		'unwanted side-effects. Consider reverting only if you experience strong issues with this new version.').'</strong> '.
		sprintf(__('You should not revert to version prior to last one (%s).'),end($archives)).
		'</p>'.
		'<p><input type="submit" name="b_del" value="'.__('Delete selected file').'" /> '.
		'<input type="submit" name="b_revert" value="'.__('Revert to selected file').'" />'.
		$core->formNonce().'</p>'.
		'</form>';
	}
}
elseif ($step == 'unzip' && !$core->error->flag())
{
	echo
	'<p class="message">'.
	__("Congratulations, you're one click away from the end of the update.").
	' <strong><a href="index.php?logout=1">'.__('Finish the update.').'</a></strong>'.
	'</p>';
}

dcPage::close();
?>