<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Dotclear 2.
#
# Copyright (c) 2003-2008 Olivier Meunier and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------
if (!defined('DC_RC_PATH')) { return; }

include dirname(__FILE__).'/_default_widgets.php';
require_once dirname(__FILE__).'/_widgets_functions.php';

$core->tpl->addValue('Widgets',array('publicWidgets','tplWidgets'));

class publicWidgets
{
	public static function tplWidgets($attr)
	{
		$type = isset($attr['type']) ? $attr['type'] : 'nav';
		
		return
		'<?php '.
		"publicWidgets::widgetsHandler('".addslashes($type)."'); ".
		' ?>';
	}
	
	public static function widgetsHandler($type)
	{
		$wtype = 'widgets_'.$type;
		$widgets = $GLOBALS['core']->blog->settings->{$wtype};
		
		if (!$widgets) { // If widgets value is empty, get defaults
			$widgets = self::defaultWidgets($type);
		} else { // Otherwise, load widgets
			$widgets = dcWidgets::load($widgets);
		}
		
		if ($widgets->isEmpty()) { // Widgets are empty, don't show anything
			return;
		}
		
		foreach ($widgets->elements() as $k => $w) {
			echo $w->call($k);
		}
	}
	
	private static function defaultWidgets($type)
	{
		$widgets = new dcWidgets();
		$w = new dcWidgets();
		
		if (isset($GLOBALS['__default_widgets'][$type])) {
			$w = $GLOBALS['__default_widgets'][$type];
		}
		
		return $w;
	}
}
?>