<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Dotclear 2.
#
# Copyright (c) 2003-2008 Olivier Meunier and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------

class dcExportFlat extends dcIeModule
{
	public function setInfo()
	{
		$this->type = 'e';
		$this->name = __('Flat file export');
		$this->description = __('Exports a blog or a full Dotclear installation to flat file.');
	}
	
	public function process($do)
	{
		if (isset($_POST['file_name'])) {
			$filename = $this->core->con->escape($_POST['file_name']);
			if (empty($filename)) {
				throw new Exception(__('Empty file name')); 
			}
		} else {
			throw new Exception(__('Empty file name')); 			
		}
		
		$fullname = $this->core->blog->public_path . '/'. $filename;

		if (file_exists($fullname)) {
			throw new Exception(__('This file already exists')); 			
		}

		# Export a blog
		if (!empty($_POST['export_blog']) && $this->core->auth->check('admin',$this->core->blog->id))
		{			
			$blog_id = $this->core->con->escape($this->core->blog->id);
			
			$exp = new dbExport($this->core->con,$fullname,$this->core->prefix);
			fwrite($exp->fp,'///DOTCLEAR|'.DC_VERSION."|single\n");
			
			$exp->export('category',
				'SELECT * FROM '.$this->core->prefix.'category '.
				"WHERE blog_id = '".$blog_id."'"
			);
			$exp->export('link',
				'SELECT * FROM '.$this->core->prefix.'link '.
				"WHERE blog_id = '".$blog_id."'"
			);
			$exp->export('setting',
				'SELECT * FROM '.$this->core->prefix.'setting '.
				"WHERE blog_id = '".$blog_id."'"
			);
			$exp->export('post',
				'SELECT * FROM '.$this->core->prefix.'post '.
				"WHERE blog_id = '".$blog_id."'"
			);
			$exp->export('media',
				'SELECT * FROM '.$this->core->prefix."media WHERE media_path = '".
				$this->core->con->escape($this->core->blog->settings->public_path)."'"
			);
			$exp->export('post_media',
				'SELECT media_id, M.post_id '.
				'FROM '.$this->core->prefix.'post_media M, '.$this->core->prefix.'post P '.
				'WHERE P.post_id = M.post_id '.
				"AND P.blog_id = '".$blog_id."'"
			);
			$exp->export('ping',
				'SELECT ping.post_id, ping_url, ping_dt '.
				'FROM '.$this->core->prefix.'ping ping, '.$this->core->prefix.'post P '.
				'WHERE P.post_id = ping.post_id '.
				"AND P.blog_id = '".$blog_id."'"
			);
			$exp->export('comment',
				'SELECT C.* '.
				'FROM '.$this->core->prefix.'comment C, '.$this->core->prefix.'post P '.
				'WHERE P.post_id = C.post_id '.
				"AND P.blog_id = '".$blog_id."'"
			);
			
			# --BEHAVIOR-- exportSingle
			$this->core->callBehavior('exportSingle',$this->core,$exp,$blog_id);
			
		}
		
		# Export all content
		if (!empty($_POST['export_all']) && $this->core->auth->isSuperAdmin())
		{	
			$exp = new dbExport($this->core->con,$fullname,$this->core->prefix);
			
			fwrite($exp->fp,'///DOTCLEAR|'.DC_VERSION."|full\n");
			$exp->exportTable('blog');
			$exp->exportTable('category');
			$exp->exportTable('link');
			$exp->exportTable('setting');
			$exp->exportTable('user');
			$exp->exportTable('permissions');
			$exp->exportTable('post');
			$exp->exportTable('media');
			$exp->exportTable('post_media');
			$exp->exportTable('log');
			$exp->exportTable('ping');
			$exp->exportTable('comment');
			$exp->exportTable('spamrule');
			$exp->exportTable('version');
			
			# --BEHAVIOR-- exportFull
			$this->core->callBehavior('exportFull',$this->core,$exp);			
		}
	}
	
	public function gui()
	{
		if (isset($_POST['file_name'])) {
			$filename = $this->core->con->escape($_POST['file_name']);		
			if (!empty($filename)) {
				echo '<p>'.__('The backup file has been created in your public directory.'). '<br />'.__('It can be downloaded here:').' <a href="'.$this->core->blog->settings->public_url . '/'. $filename.'">'.$filename.'</a>.</p>';			
				return;
			}
		}
		
		echo
		'<form action="'.$this->getURL(true).'" method="post">'.
		'<fieldset><legend>'.__('Export a blog').'</legend>'.
		'<p>'.sprintf(__('This will create an export of your current blog: %s'),
		'<strong>'.html::escapeHTML($this->core->blog->name).'</strong>').'</p>'.
		'<p><label class="classic">'.__('File name:').' '.
		form::field(array('file_name'),25,255,html::escapeHTML($this->core->blog->id.'-backup.txt')).
		'</label> '.
		'<input name="export_blog" type="submit" value="'.__('Export').'" /></p>'.
		form::hidden(array('do'),1).
		$this->core->formNonce().'</p>'.
		'</fieldset></form>';
		
		if ($this->core->auth->isSuperAdmin())
		{
			echo
			'<form action="'.$this->getURL(true).'" method="post">'.
			'<fieldset><legend>'.__('Export all content').'</legend>'.
			'<p><label class="classic">'.__('File name:').' '.
			form::field(array('file_name'),25,255,'dotclear-backup.txt').
			'</label> '.
			'<input name="export_all" type="submit" value="'.__('Export all content').'" />'.
			form::hidden(array('do'),1).
			$this->core->formNonce().'</p>'.
			'</fieldset></form>';
		}
	}
}
?>