<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Dotclear 2.
#
# Copyright (c) 2003-2008 Olivier Meunier and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('categories');

# Remove categories
if (!empty($_POST['removeaction']) && !empty($_POST['remove']) && is_array($_POST['remove']))
{
	foreach ($_POST['remove'] as $v)
	{
		try {
			$core->blog->delCategory($v);
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
			break;
		}
	}
	
	if (!$core->error->flag()) {
		http::redirect('categories.php?del=1');
	}
}

# Order
$order = array();
if (empty($_POST['categories_order']) && !empty($_POST['order'])) {
	$order = $_POST['order'];
	asort($order);
	$order = array_keys($order);
} elseif (!empty($_POST['categories_order'])) {
	$order = explode(',',$_POST['categories_order']);
}

if (!empty($_POST['saveorder']) && !empty($order))
{
	foreach ($order as $pos => $c) {
		$pos = ((integer) $pos)+1;
		
		try {
			$core->blog->updCategoryOrder($c,$pos);
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
	}
	
	if (!$core->error->flag()) {
		http::redirect('categories.php?neworder=1');
	}
}

try {
	$rs = $core->blog->getCategories();
} catch (Exception $e) {
	$core->error->add($e->getMessage());
}

/* Display
-------------------------------------------------------- */
dcPage::open(__('Categories'),
	dcPage::jsConfirmClose('form-categories').
	dcPage::jsToolMan()."\n".
	dcPage::jsLoad('js/_categories.js').
	dcPage::jsLoad('js/confirmClose.js')
);

if (!$core->error->flag())
{
	if (!empty($_GET['neworder'])) {
		echo '<p class="message">'.__('Category order has been successfully updated.').'</p>';
	}
	
	if (!empty($_GET['add'])) {
		echo '<p class="message">'.__('The category has been successfully created.').'</p>';
	}
	
	if (!empty($_GET['del'])) {
		echo '<p class="message">'.__('Categories have been successfully removed.').'</p>';
	}
	
	echo '<h2>'.html::escapeHTML($core->blog->name).' &gt; '.__('Categories').'</h2>';
	
	echo
	'<form action="category.php" method="post">'.
	'<p><label class="classic">'.__('Title:').
	form::field('cat_title',20,255,'','',2).
	'</label> '.
	'<input type="submit" value="'.__('Create new category').'" />'.
	$core->formNonce().'</p>'.
	'</form>';
	
	if ($rs->isEmpty())
	{
		echo '<p>'.__('No category.').'</p>';
	}
	else
	{
		echo
		'<form action="categories.php" method="post" id="form-categories">'.
		'<table class="dragable">'.
		'<thead><tr><th colspan="3">'.__('Name').'</th>'.
		'<th>'.__('Entries').'</th>'.
		'</tr></thead>'.
		'<tbody id="categories-list">';
		
		while ($rs->fetch())
		{
			$deletable = false;
			
			$posts_link = '<a href="posts.php?cat_id=%s">%s</a>';
			
			switch ($rs->nb_post) {
				case 0:
					$nb_post = __('No entry');
					$deletable = true;
					break;
				case 1:
					$nb_post = sprintf($posts_link,$rs->cat_id,__('1 entry'));
					break;
				default:
					$nb_post = sprintf($posts_link,$rs->cat_id,
					sprintf(__('%d entries'),$rs->nb_post));
					break;
			}
			
			$position = (string) $rs->index()+1;
			
			echo
			'<tr class="line" id="c_'.$rs->cat_id.'">'.
			'<td class="handle">'.form::field(array('order['.$rs->cat_id.']'),2,5,$position).'</td>'.
			'<td>'.($rs->nb_post==0 ? form::checkbox(array('remove[]'),$rs->cat_id) : '').'</td>'.
			'<td class="maximal"><a href="category.php?id='.$rs->cat_id.'">'.
			html::escapeHTML($rs->cat_title).'</a></td>'.
			'<td class="nowrap">'.$nb_post.'</td>'.
			'</tr>';
		}
		
		echo
		'</tbody></table>'.
		
		'<div class="two-cols">'.
		'<p class="col">'.form::hidden('categories_order','').
		'<input type="submit" name="saveorder" value="'.__('Save order').'" />'.
		'</p>'.
		
		'<p class="col right"><input type="submit" name="removeaction" '.
		'value="'.__('Delete selected categories').'" />'.
		$core->formNonce().'</p>'.
		'</div>'.
		'</form>';
	}
}

dcPage::helpBlock('core_categories');
dcPage::close(); ?>