<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of Dotclear 2.
#
# Copyright (c) 2003-2008 Olivier Meunier and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------

class defaultWidgets
{
	public static function search(&$w)
	{
		global $core;
		
		$value = isset($GLOBALS['_search']) ? html::escapeHTML($GLOBALS['_search']) : '';
		
		return
		'<div id="search">'.
		($w->title ? '<h2><label for="q">'.html::escapeHTML($w->title).'</label></h2>' : '').
		'<form action="'.$core->blog->url.'" method="get">'.
		'<fieldset>'.
		'<p><input type="text" size="10" maxlength="255" id="q" name="q" value="'.$value.'" /> '.
		'<input class="submit" type="submit" value="ok" /></p>'.
		'</fieldset>'.
		'</form>'.
		'</div>';
	}
	
	public static function navigation(&$w)
	{
		global $core;
		
		$res =
		'<div id="topnav">'.
		'<ul>';
		
		if ($core->url->type != 'default') {
			$res .=
			'<li class="topnav-home">'.
			'<a href="'.$core->blog->url.'">'.__('Home').'</a>'.
			'<span> - </span></li>';
		}
		
		$res .=
		'<li class="topnav-arch">'.
		'<a href="'.$core->blog->url.$core->url->getBase("archive").'">'.
		__('Archives').'</a></li>'.
		'</ul>'.
		'</div>';
		
		return $res;
	}
	
	public static function categories(&$w)
	{
		global $core;
		
		$rs = $core->blog->getCategories(array('post_type'=>'post'));
		if ($rs->isEmpty()) {
			return;
		}
		
		$res =
		'<div class="categories">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		'<ul>';
		
		while ($rs->fetch()) {
			$res .=
			'<li><a href="'.$core->blog->url.$core->url->getBase('category').'/'.
			$rs->cat_url.'">'.
			html::escapeHTML($rs->cat_title).'</a>'.
			($w->postcount ? ' ('.$rs->nb_post.')' : '').
			'</li>';
		}
		$res .= '</ul></div>';
		
		return $res;
	}
	
	public static function bestof(&$w)
	{
		global $core;
		
		if ($w->homeonly && $core->url->type != 'default') {
			return;
		}
		
		$params = array(
			'post_selected'=>true,
			'no_content'=>true,
			'order'=>'post_dt desc');
		
		$rs = $core->blog->getPosts($params);
		
		if ($rs->isEmpty()) {
			return;
		}
		
		$res =
		'<div class="selected">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		'<ul>';
		
		while ($rs->fetch()) {
			$res .= ' <li><a href="'.$rs->getURL().'">'.html::escapeHTML($rs->post_title).'</a></li> ';
		}
		
		$res .= '</ul></div>';
		
		return $res;
	}
	
	public static function langs(&$w)
	{
		global $core, $_ctx;
		
		if ($w->homeonly && $core->url->type != 'default' && $core->url->type != 'lang') {
			return;
		}
		
		$rs = $core->blog->getLangs();
		
		if ($rs->count() <= 1) {
			return;
		}
		
		$langs = l10n::getISOcodes();
		$res =
		'<div class="langs">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		'<ul>';
		
		while ($rs->fetch())
		{
			$l = ($_ctx->cur_lang == $rs->post_lang) ? '<strong>%s</strong>' : '%s';
			
			$lang_name = isset($langs[$rs->post_lang]) ? $langs[$rs->post_lang] : $rs->post_lang;
			
			$res .=
			' <li>'.
			sprintf($l,
				'<a href="'.$core->blog->url.$core->url->getBase('lang').$rs->post_lang.'" '.
				'class="lang-'.$rs->post_lang.'">'.
				$lang_name.'</a>').
			' </li>';
		}
		
		$res .= '</ul></div>';
		
		return $res;
	}
	
	public static function subscribe(&$w)
	{
		global $core;
		
		$type = ($w->type == 'atom' || $w->type == 'rss2') ? $w->type : 'rss2';
		$mime = $type == 'rss2' ? 'application/rss+xml' : 'application/atom+xml';
		
		$p_title = __('This blog\'s entries %s feed');
		$c_title = __('This blog\'s comments %s feed');
		
		$res =
		'<div class="syndicate">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		'<ul>';
		
		$res .=
		'<li><a type="'.$mime.'" '.
		'href="'.$core->blog->url.$core->url->getBase('feed').'/'.$type.'" '.
		'title="'.sprintf($p_title,($type == 'atom' ? 'Atom' : 'RSS')).'" class="feed">'.
		__('Entries feed').'</a></li>';
		
		if ($core->blog->settings->allow_comments || $core->blog->settings->allow_trackbacks)
		{
			$res .=
			'<li><a type="'.$mime.'" '.
			'href="'.$core->blog->url.$core->url->getBase('feed').'/'.$type.'/comments" '.
			'title="'.sprintf($c_title,($type == 'atom' ? 'Atom' : 'RSS')).'" class="feed">'.
			__('Comments feed').'</a></li>';
		}
		
		$res .= '</ul></div>';
		
		return $res;
	}
	
	public static function feed(&$w)
	{
		if (!$w->url) {
			return;
		}
		
		global $core;
		
		if ($w->homeonly && $core->url->type != 'default') {
			return;
		}
		
		$limit = abs((integer) $w->limit);
		
		try {
			$feed = feedReader::quickParse($w->url,DC_TPL_CACHE);
			if ($feed == false || count($feed->items) == 0) {
				return;
			}
		} catch (Exception $e) {
			return;
		}
		
		$res =
		'<div class="feed">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		'<ul>';
		
		$i = 0;
		foreach ($feed->items as $item) {
			$res .= ' <li><a href="'.$item->link.'">'.$item->title.'</a></li> ';
			$i++;
			if ($i >= $limit) {
				break;
			}
		}
		
		$res .= '</ul></div>';
		
		return $res;
	}
	
	public static function text(&$w)
	{
		global $core;
		
		if ($w->homeonly && $core->url->type != 'default') {
			return;
		}
		
		$res =
		'<div class="text">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		$w->text.
		'</div>';
		
		return $res;
	}
	
	public static function lastposts(&$w)
	{
		global $core;
		
		if ($w->homeonly && $core->url->type != 'default') {
			return;
		}
		
		$params['limit'] = abs((integer) $w->limit);
		$params['order'] = 'post_dt desc';
		$params['no_content'] = true;
		$rs = $core->blog->getPosts($params);
		
		if ($rs->isEmpty()) {
			return;
		}
		
		$res =
		'<div class="lastposts">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		'<ul>';
		
		while ($rs->fetch()) {
			$res .= '<li><a href="'.$rs->getURL().'">'.
			html::escapeHTML($rs->post_title).'</a></li>';
		}
		
		$res .= '</ul></div>';
		
		return $res;
	}
	
	public static function lastcomments(&$w)
	{
		global $core;
		
		if ($w->homeonly && $core->url->type != 'default') {
			return;
		}
		
		$params['limit'] = abs((integer) $w->limit);
		$params['order'] = 'comment_dt desc';
		$rs = $core->blog->getComments($params);
		
		if ($rs->isEmpty()) {
			return;
		}
		
		$res = '<div class="lastcomments">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		'<ul>';
		
		while ($rs->fetch())
		{
			$res .= '<li><a href="'.$rs->getPostURL().'#c'.$rs->comment_id.'">'.
			html::escapeHTML($rs->post_title).' - '.
			html::escapeHTML($rs->comment_author).
			'</a></li>';
		}
		
		$res .= '</ul></div>';
		
		return $res;
	}
}
?>