<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2008 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****
if (!defined('DC_CONTEXT_ADMIN')) { exit; }

require dirname(__FILE__).'/class.themeEditor.php';

$o = new dcThemeEditor($core);
$file_default = $file = array('c'=>null, 'w'=>false, 'type'=>null, 'f'=>null, 'default_file'=>false);

# Loading themes
$core->themes = new dcModules($core);
$core->themes->loadModules($core->blog->themes_path,null);
$T = $core->themes->getModules($core->blog->settings->theme);

try
{
	try
	{
		if (!empty($_REQUEST['tpl'])) {
			$file = $o->getFileContent('tpl',$_REQUEST['tpl']);
		} elseif (!empty($_REQUEST['css'])) {
			$file = $o->getFileContent('css',$_REQUEST['css']);
		} elseif (!empty($_REQUEST['js'])) {
			$file = $o->getFileContent('js',$_REQUEST['js']);
		}
	}
	catch (Exception $e)
	{
		$file = $file_default;
		throw $e;
	}
	
	# Write file
	if (!empty($_POST['write']))
	{
		$file['c'] = $_POST['file_content'];
		$o->writeFile($file['type'],$file['f'],$file['c']);
	}
}
catch (Exception $e)
{
	$core->error->add($e->getMessage());
}
?>

<html>
<head>
  <title><?php echo __('Theme Editor'); ?></title>
  <link rel="stylesheet" type="text/css" href="index.php?pf=themeEditor/style.css" />
  <script type="text/javascript">
  //<![CDATA[
  <?php echo dcPage::jsVar('dotclear.msg.saving_document',__("Saving document...")); ?>
  <?php echo dcPage::jsVar('dotclear.msg.document_saved',__("Document saved")); ?>
  <?php echo dcPage::jsVar('dotclear.msg.error_occured',__("An error occured:")); ?>
  //]]>
  </script>
  <script type="text/javascript" src="index.php?pf=themeEditor/script.js"></script>
</head>

<body>
<?php echo '<h2>'.html::escapeHTML($core->blog->name).
' &gt; <a href="blog_theme.php">'.__('Theme settings').'</a> &gt; '.__('Theme Editor').'</h2>'; ?>

<p><strong><?php echo sprintf(__('Your current theme on this blog is "%s".'),html::escapeHTML($T['name'])); ?></strong></p>

<?php if ($core->blog->settings->theme == 'default') { ?>
	<div class="error"><p><?php echo __("You can't edit default theme."); ?></p></div>
	</body></html>
<?php } ?>

<div id="file-box">
<div id="file-editor">
<?php
if ($file['c'] === null)
{
	echo '<p>'.__('Please select a file to edit.').'</p>';
}
else
{
	echo
	'<form id="file-form" action="'.$p_url.'" method="post">'.
	'<fieldset><legend>'.__('File editor').'</legend>'.
	'<p>'.sprintf(__('Editing file %s'),'<strong>'.$file['f']).'</strong></p>'.
	'<p>'.form::textarea('file_content',72,25,html::escapeHTML($file['c']),'maximal','',!$file['w']).'</p>';
	
	if ($file['w'])
	{
		echo
		'<p><input type="submit" name="write" value="'.__('save').' (s)" accesskey="s" /> '.
		$core->formNonce().
		($file['type'] ? form::hidden(array($file['type']),$file['f']) : '').
		'</p>';
	}
	else
	{
		echo '<p>'.__('This file is not writable. Please check your theme files permissions.').'</p>';
	}
	
	echo
	'</fieldset></form>';
}
?>
</div>
</div>

<div id="file-chooser">
<h3><?php echo __('Templates files'); ?></h3>
<?php echo $o->filesList('tpl','<a href="'.$p_url.'&amp;tpl=%2$s" class="tpl-link">%1$s</a>'); ?>

<h3><?php echo __('CSS files'); ?></h3>
<?php echo $o->filesList('css','<a href="'.$p_url.'&amp;css=%2$s" class="css-link">%1$s</a>'); ?>

<h3><?php echo __('JavaScript files'); ?></h3>
<?php echo $o->filesList('js','<a href="'.$p_url.'&amp;js=%2$s" class="js-link">%1$s</a>'); ?>
</div>

<?php dcPage::helpBlock('themeEditor'); ?>
</body>
</html>