<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class dbExport
{
	private $con;
	private $prefix;
	
	private $line_reg = array('/\n/u','/\r/u','/"/u');
	private $line_rep = array('\n'   ,'\r'   ,'\"');
	
	public $fp;
	
	function __construct(&$con,$out='php://output',$prefix=null)
	{
		$this->con =& $con;
		$this->prefix = $prefix;
		
		if (($this->fp = fopen($out,'w')) === false) {
			return false;
		}
		@set_time_limit(300);
	}
	
	function __destruct()
	{
		if (is_resource($this->fp)) {
			fclose($this->fp);
		}
	}
	
	function export($name,$sql)
	{
		$rs = $this->con->select($sql);
		
		if (!$rs->isEmpty())
		{
			fwrite($this->fp,"\n[".$name.' '.implode(',',$rs->columns())."]\n");
			while ($rs->fetch()) {
				fwrite($this->fp,$this->getLine($rs));
			}
			fflush($this->fp);
		}
	}
	
	function exportAll()
	{
		$tables = $this->getTables();
		
		foreach ($tables as $table)
		{
			$this->exportTable($table);
		}
	}
	
	function exportTable($table)
	{
		$req = 'SELECT * FROM '.$this->con->escapeSystem($this->prefix.$table);
		
		$this->export($table,$req);
	}
	
	function getTables()
	{
		$schema = dbSchema::init($this->con);
		$db_tables = $schema->getTables();
		
		$tables = array();
		foreach ($db_tables as $t)
		{
			if ($this->prefix) {
				if (strpos($t,$this->prefix) === 0) {
					$tables[] = $t;
				}
			} else {
				$tables[] = $t;
			}
		}
		
		return $tables;
	}
	
	function getLine(&$rs)
	{
		$l = array();
		$cols = $rs->columns();
		foreach ($cols as $i => &$c) {
			$s = $rs->f($c);
			$s = preg_replace($this->line_reg,$this->line_rep,$s);
			$s = '"'.$s.'"';
			$l[$i] = $s;
		}
		return implode(',',$l)."\n";
	}
}
?>