<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of Antispam, a plugin for DotClear.  
# Copyright (c) 2007 Alain Vagner and contributors. All rights
# reserved.
#
# Antispam is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# Antispam is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Antispam; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!defined('DC_CONTEXT_ADMIN')) { exit; }

$version = $core->plugins->moduleInfo('antispam','version');
if (version_compare($core->getVersion('antispam'),$version,'>=')) {
	return;
}

/* Database schema
-------------------------------------------------------- */
$s = new dbStruct($core->con,$core->prefix);

$s->spamrule
	->rule_id		('bigint',	0,	false)
	->blog_id		('varchar',	32,	true)
	->rule_type	('varchar',	16,	false,	"'word'")
	->rule_content	('varchar',	128,	false)
	
	->primary('pk_spamrule','rule_id')
	;

$s->spamrule->index('idx_spamrule_blog_id','btree','blog_id');
$s->spamrule->reference('fk_spamrule_blog','blog_id','blog','blog_id','cascade','cascade');

if ($s->driver() == 'pgsql') {
	$s->spamrule->index		('idx_spamrule_blog_id_null',	'btree',	'(blog_id IS NULL)');
}

# Schema installation
$si = new dbStruct($core->con,$core->prefix);
$changes = $si->synchronize($s);

# Creating default wordslist
if ($core->getVersion('antispam') === null) {
	$_o = new dcFilterWords($core);
	$_o->defaultWordsList();
	unset($_o);
}

$core->setVersion('antispam',$version);
return true;
?>