<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (isset($_SERVER['DC_RC_PATH'])) {
	define('DC_RC_PATH',$_SERVER['DC_RC_PATH']);
} elseif (isset($_SERVER['REDIRECT_DC_RC_PATH'])) {
	define('DC_RC_PATH',$_SERVER['REDIRECT_DC_RC_PATH']);
} else {
	define('DC_RC_PATH',dirname(__FILE__).'/config.php');
}

if (!is_file(DC_RC_PATH)) {
	trigger_error('Unable to open config file',E_USER_ERROR);
	exit;
}

require DC_RC_PATH;

#  ClearBricks and DotClear classes auto-loader
if (@is_dir('/usr/lib/clearbricks')) {
	define('CLEARBRICKS_PATH','/usr/lib/clearbricks');
} elseif (is_dir(dirname(__FILE__).'/clearbricks')) {
	define('CLEARBRICKS_PATH',dirname(__FILE__).'/clearbricks');
} elseif (isset($_SERVER['CLEARBRICKS_PATH']) && is_dir($_SERVER['CLEARBRICKS_PATH'])) {
	define('CLEARBRICKS_PATH',$_SERVER['CLEARBRICKS_PATH']);
}

if (!defined('CLEARBRICKS_PATH') || !is_dir(CLEARBRICKS_PATH)) {
	exit('No clearbricks path defined');
}

require CLEARBRICKS_PATH.'/_common.php';

if (empty($_GET['pf'])) {
	header('Content-Type: text/plain');
	http::head(404,'Not Found');
	exit;
}

$allow_types = array('png','jpg','jpeg','gif','css','js','swf');

$pf = path::clean($_GET['pf']);

$paths = array_reverse(explode(PATH_SEPARATOR,DC_PLUGINS_ROOT));

# Adding admin/res folder here to load some stuff
$paths[] = dirname(__FILE__).'/../admin/res';

foreach ($paths as $m)
{
	$PF = path::real($m.'/'.$pf);
	
	if ($PF !== false) {
		break;
	}
}
unset($paths);

if ($PF === false || !is_file($PF) || !is_readable($PF)) {
	header('Content-Type: text/plain');
	http::head(404,'Not Found');
	exit;
}

if (!in_array(files::getExtension($PF),$allow_types)) {
	header('Content-Type: text/plain');
	http::head(404,'Not Found');
	exit;
}

http::cache(array_merge(array($PF),get_included_files()));

header('Content-Type: '.files::getMimeType($PF));
header('Content-Length: '.filesize($PF));
readfile($PF);
exit;
?>