<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require_once dirname(__FILE__).'/../prepend.php';

// HTTP/1.1
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');

// HTTP/1.0
header("Pragma: no-cache");

define('DC_CONTEXT_ADMIN',true);

# If we have a session we launch it now
if (isset($_COOKIE[DC_SESSION_NAME]))
{
	$core->session->start();
	
	# If session does not exist, logout.
	if (!isset($_SESSION['sess_user_id'])) {
		$core->session->destroy();
		http::redirect('auth.php');
	}
	
	# Check here for user and IP address
	$core->auth->checkUser($_SESSION['sess_user_id']);
	
	$user_can_log =
	$core->auth->userID() !== null &&
	(http::browserUID(DC_MASTER_KEY) == $_SESSION['sess_browser_uid']);
	
	if (!$user_can_log) {
		$core->session->destroy();
		http::redirect('auth.php');
	}
	unset($user_can_log);
	
	# Check nonce from POST requests
	if (!empty($_POST))
	{
		if (empty($_POST['xd_check']) || !$core->checkNonce($_POST['xd_check'])) {
			http::head(412);
			header('Content-Type: text/plain');
			echo 'Precondition Failed';
			exit;
		}
	}
	
	# Loading locales
	$_lang = $core->auth->getInfo('user_lang');
	$_lang = preg_match('/^[a-z]{2}$/',$_lang) ? $_lang : 'en';
	
	if (l10n::set(dirname(__FILE__).'/../../locales/'.$_lang.'/date') === false && $_lang != 'en') {
		l10n::set(dirname(__FILE__).'/../../locales/en/date');
	}
	l10n::set(dirname(__FILE__).'/../../locales/'.$_lang.'/main');
	l10n::set(dirname(__FILE__).'/../../locales/'.$_lang.'/langs');
	
	# Loading resources file
	$f = l10n::getFilePath(dirname(__FILE__).'/../../locales/','resources.php',$_lang);
	if ($f) {
		require $f;
	}
	unset($f);
	
	$core->getUserBlogs();
	
	if (!empty($_REQUEST['switchblog'])
	&& isset($core->blogs[$_REQUEST['switchblog']]))
	{
		$_SESSION['sess_blog_id'] = $_REQUEST['switchblog'];
		if (isset($_SESSION['media_manager_dir'])) {
			unset($_SESSION['media_manager_dir']);
		}
		if (isset($_SESSION['media_manager_page'])) {
			unset($_SESSION['media_manager_page']);
		}
		
		# Removing switchblog from URL
		$redir = $_SERVER['REQUEST_URI'];
		$redir = preg_replace('/switchblog=(.*?)(&|$)/','',$redir);
		$redir = preg_replace('/\?$/','',$redir);
		http::redirect($redir);
		exit;
	}
	
	# Check blog to use and log out if no result
	$b = array_keys($core->blogs);
	if (isset($_SESSION['sess_blog_id']))
	{
		if (!in_array($_SESSION['sess_blog_id'],$b)) {
			unset($_SESSION['sess_blog_id']);
		}
	}
	else
	{
		if (in_array($core->auth->getInfo('user_default_blog'),$b)) {
			$_SESSION['sess_blog_id'] = $core->auth->getInfo('user_default_blog');
		} elseif (count($b) > 0) {
			$_SESSION['sess_blog_id'] = $b[0];
		}
	}
	unset($b);
	
	if (isset($_SESSION['sess_blog_id'])) {
		$core->setBlog($_SESSION['sess_blog_id']);
	} else {
		$core->session->destroy();
		http::redirect('auth.php');
	}
	
	# Menus creation
	$_menu['System'] = new dcMenu('system-menu',__('System'));
	$_menu['Blog'] = new dcMenu('blog-menu',__('Blog'));
	$_menu['Plugins'] = new dcMenu('plugins-menu',__('Plugins'));
	
	$_menu['System']->addItem(__('Dashboard'),'index.php','images/menu/dashboard.png',
		preg_match('/index.php$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('usage,contentadmin',$core->blog->id));
	$_menu['System']->addItem(__('Blogs'),'blogs.php','images/menu/blogs.png',
		preg_match('/blogs.php$/',$_SERVER['REQUEST_URI']),
		$core->auth->isSuperAdmin() ||
		$core->auth->check('usage,contentadmin',$core->blog->id) && count($core->blogs) > 1);
	$_menu['System']->addItem(__('Users'),'users.php','images/menu/users.png',
		preg_match('/users.php$/',$_SERVER['REQUEST_URI']),
		$core->auth->isSuperAdmin());
	$_menu['System']->addItem(__('Plugins'),'plugins.php','images/menu/plugins.png',
		preg_match('/plugins.php$/',$_SERVER['REQUEST_URI']),
		$core->auth->isSuperAdmin());
	
	$_menu['Blog']->addItem(__('New entry'),'post.php','images/menu/edit.png',
		preg_match('/post.php$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('usage,contentadmin',$core->blog->id));
	$_menu['Blog']->addItem(__('Entries'),'posts.php','images/menu/entries.png',
		preg_match('/posts.php(\?.*)?$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('usage,contentadmin',$core->blog->id));
	$_menu['Blog']->addItem(__('Comments'),'comments.php','images/menu/comments.png',
		preg_match('/comments.php(\?.*)?$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('usage,contentadmin',$core->blog->id));
	$_menu['Blog']->addItem(__('Search'),'search.php','images/menu/search.png',
		preg_match('/search.php(\?.*)?$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('usage,contentadmin',$core->blog->id));
	$_menu['Blog']->addItem(__('Categories'),'categories.php','images/menu/categories.png',
		preg_match('/categories.php(\?.*)?$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('categories',$core->blog->id));
	$_menu['Blog']->addItem(__('Media manager'),'media.php','images/menu/media.png',
		preg_match('/media(_item)?.php(\?.*)?$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('media,media_admin',$core->blog->id));
	
	# Loading plugins
	$core->plugins->loadModules(DC_PLUGINS_ROOT,'admin',$_lang);
}
?>