<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

define('DC_AUTH_PAGE','auth.php');

class dcPage
{
	# Auth check
	public static function check($permissions)
	{
		global $core;
		
		if ($core->blog && $core->auth->check($permissions,$core->blog->id))
		{
			return;
		}
		
		if (session_id()) {
			$core->session->destroy();
		}
		http::redirect(DC_AUTH_PAGE);
	}
	
	# Check super admin
	public static function checkSuper()
	{
		global $core;
		
		if (!$core->auth->isSuperAdmin())
		{
			if (session_id()) {
				$core->session->destroy();
			}
			http::redirect(DC_AUTH_PAGE);
		}
	}
	
	public static function getTextDirection()
	{
		# We don't want it to be caught by po_update
		if (isset($GLOBALS['__l10n']['_direction']) && $GLOBALS['__l10n']['_direction'] == 'rtl') {
			return 'rtl';
		}
		return 'ltr';
	}
	
	# Top of admin page
	public static function open($title='', $head='')
	{
		global $core, $dc_blogs;
		
		# List of user's blogs
		$blogs = array();
		
		foreach ($core->blogs as $k=>$v) {
			$blogs[html::escapeHTML($v['name']).' - '.$v['url']] = $k;
		}
		
		if (count($blogs) == 1 || count($blogs) > 20)
		{
			$blog_box =
			__('Blog:').' <strong title="'.html::escapeHTML($core->blog->url).'">'.
			html::escapeHTML($core->blog->name).'</strong>';
			
			if (count($blogs) > 20) {
				$blog_box .= ' - <a href="blogs.php">'.__('Change blog').'</a>';
			}
		}
		else
		{
			uasort($blogs,create_function('$a,$b','return !strcmp(strtolower($a),strtolower($b));'));
			$blog_box =
			__('Blogs:').' '.
			$core->formNonce().
			form::combo('switchblog',$blogs,$core->blog->id,	'',1).
			'<noscript><div><input type="submit" value="'.__('ok').'" /></div></noscript>';
		}
		
		$body_rtl = self::getTextDirection() == 'rtl' ? ' class="rtl"' : '';
		
		# Display
		header('Content-Type: text/html; charset=UTF-8');
		echo
		'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" '.
		' "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n".
		'<html xmlns="http://www.w3.org/1999/xhtml" '.
		'xml:lang="'.$core->auth->getInfo('user_lang').'" '.
		'lang="'.$core->auth->getInfo('user_lang').'">'."\n".
		"<head>\n".
		'  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />'."\n".
		'  <title>'.$title.' - '.html::escapeHTML($core->blog->name).' - '.DC_VENDOR_NAME.' - '.DC_VERSION.'</title>'."\n".
		
		'  <meta name="MSSmartTagsPreventParsing" content="TRUE" />'."\n".
		'  <meta name="ROBOTS" content="NOARCHIVE,NOINDEX,NOFOLLOW" />'."\n".
		'  <meta name="GOOGLEBOT" content="NOSNIPPET" />'."\n".
		
		self::jsLoadIE7().
		'  <style type="text/css">'."\n". 
		'  @import "style/default.css";'."\n".
		"  </style>\n";
		
		# --BEHAVIOR-- adminPageHTMLHead
		$core->callBehavior('adminPageHTMLHead');
		
		echo
		self::jsCommon().
		$head.
		"</head>\n".
		'<body id="dotclear-admin"'.$body_rtl.'>'."\n".
		
		'<div id="top"><h1><a href="index.php">'.DC_VENDOR_NAME.'</a></h1></div>'."\n";
		
		
		echo
		'<div id="info-box">'.
		'<form action="index.php" method="post"><div>'.
		$blog_box.
		' - <a href="'.$core->blog->url.'">'.__('View site').'</a>'.
		' - '.__('User:').' <strong>'.$core->auth->userID().'</strong>'.
		' - <a href="index.php?logout=1">'.__('Logout').'</a>'.
		'</div></form>'.
		'</div>';
		
		echo
		'<div id="main">'."\n".
		'<div id="content">'."\n";
		
		if ($core->error->flag()) {
			echo
			'<div class="error"><strong>'.__('Errors:').'</strong>'.
			$core->error->toHTML().
			'</div>';
		}
	}
	
	public static function close()
	{
		$menu =& $GLOBALS['_menu'];
		
		echo
		"</div>\n".		// End of #content
		"</div>\n".		// End of #main
		
		'<div id="main-menu">'."\n";
		
		foreach ($menu as $k => $v) {
			echo $menu[$k]->draw();
		}
		
		echo
		'</div>'."\n".
		'<p id="footer"><a href="http://www.dotclear.net/"><img '.
		'src="images/dotclear_pw.png" alt="dotclear blog" /></a></p>'."\n";
		
		if (defined('DC_DEV') && DC_DEV === true) {
			echo self::debugInfo();
		}
		
		echo
		'</body></html>';
	}
	
	public static function openPopup($title='', $head='')
	{
		global $core, $dc_blogs;
		
		$body_rtl = self::getTextDirection() == 'rtl' ? ' rtl' : '';
		
		# Display
		header('Content-Type: text/html; charset=UTF-8');
		echo
		'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" '.
		' "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n".
		'<html xmlns="http://www.w3.org/1999/xhtml" '.
		'xml:lang="'.$core->auth->getInfo('user_lang').'" '.
		'lang="'.$core->auth->getInfo('user_lang').'">'."\n".
		"<head>\n".
		'  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />'."\n".
		'  <title>'.$title.' - '.html::escapeHTML($core->blog->name).' - '.DC_VENDOR_NAME.' - '.DC_VERSION.'</title>'."\n".
		
		'  <meta name="MSSmartTagsPreventParsing" content="TRUE" />'."\n".
		'  <meta name="ROBOTS" content="NOARCHIVE,NOINDEX,NOFOLLOW" />'."\n".
		'  <meta name="GOOGLEBOT" content="NOSNIPPET" />'."\n".
		
		self::jsLoadIE7().
		'  <style type="text/css">'."\n". 
		'  @import "style/default.css";'."\n".
		"  </style>\n";
		
		# --BEHAVIOR-- adminPageHTMLHead
		$core->callBehavior('adminPageHTMLHead');
		
		echo
		self::jsCommon().
		$head.
		"</head>\n".
		'<body id="dotclear-admin" class="popup'.$body_rtl.'">'."\n".
		
		'<div id="top"><h1>'.DC_VENDOR_NAME.'</h1></div>'."\n";
		
		echo
		'<div id="main">'."\n".
		'<div id="content">'."\n";
		
		if ($core->error->flag()) {
			echo
			'<div class="error"><strong>'.__('Errors:').'</strong>'.
			$core->error->toHTML().
			'</div>';
		}
	}
	
	public static function closePopup()
	{
		echo
		"</div>\n".		// End of #content
		"</div>\n".		// End of #main
		
		'</body></html>';
	}
	
	private static function debugInfo()
	{
		$global_vars = implode(', ',array_keys($GLOBALS));
		
		$res =
		'<div id="debug"><div>'.
		'<p>memory usage: '.memory_get_usage().' ('.files::size(memory_get_usage()).')</p>';
		
		if (function_exists('xdebug_get_profiler_filename'))
		{
			$res .= '<p>Elapsed time: '.xdebug_time_index().' seconds</p>';
			
			$prof_file = xdebug_get_profiler_filename();
			if ($prof_file) {
				$res .= '<p>Profiler file : '.xdebug_get_profiler_filename().'</p>';
			} else {
				$prof_url = http::getSelfURI();
				$prof_url .= (strpos($prof_url,'?') === false) ? '?' : '&amp;';
				$prof_url .= 'XDEBUG_PROFILE';
				$res .= '<p><a href="'.$prof_url.'">Trigger profiler</a></p>';
			}
			
			/* xdebug configuration:
			zend_extension = /.../xdebug.so
			xdebug.auto_trace = On
			xdebug.trace_format = 0
			xdebug.trace_options = 1
			xdebug.show_mem_delta = On
			xdebug.profiler_enable = 0
			xdebug.profiler_enable_trigger = 1
			xdebug.profiler_output_dir = /tmp
			xdebug.profiler_append = 0
			xdebug.profiler_output_name = timestamp
			*/
		}
		
		$res .=
		'<p>Global vars: '.$global_vars.'</p>'.
		'</div></div>';
		
		return $res;
	}
	
	public static function help($page,$index='')
	{
		# Deprecated but we keep this for plugins.
	}
	
	public static function helpBlock()
	{
		$args = func_get_args();
		if (empty($args)) {
			return;
		};
		
		global $__resources;
		if (empty($__resources['help'])) {
			return;
		}
		
		$content = '';
		foreach ($args as $v)
		{
			if (!isset($__resources['help'][$v])) {
				continue;
			}
			$f = $__resources['help'][$v];
			if (!file_exists($f) || !is_readable($f)) {
				continue;
			}
			
			$fc = file_get_contents($f);
			if (preg_match('|<body[^>]*?>(.*?)</body>|ms',$fc,$matches)) {
				$content .= $matches[1];
			} else {
				$content .= $fc;
			}
		}
		
		if (trim($content) == '') {
			return;
		}
		
		echo
		'<div id="help"><hr /><div class="help-content"><h2>'.__('Help').'</h2>'.
		$content.
		'</div></div>';
	}
	
	public static function jsLoad($src)
	{
		return '<script type="text/javascript" src="'.html::escapeHTML($src).'"></script>'."\n";
	}
	
	public static function jsVar($n,$v)
	{
		return $n." = '".html::escapeJS($v)."';\n";
	}
	
	public static function jsCommon()
	{
		return
		self::jsLoad('js/jquery/jquery.js').
		self::jsLoad('js/jquery/jquery.cookie.js').
		self::jsLoad('js/jquery/jquery.bgFade.js').
		self::jsLoad('js/common.js').
		
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		self::jsVar('dotclear.nonce',$GLOBALS['core']->getNonce()).
		
		self::jsVar('dotclear.img_plus_src','images/plus.png').
		self::jsVar('dotclear.img_plus_alt',__('uncover')).
		self::jsVar('dotclear.img_minus_src','images/minus.png').
		self::jsVar('dotclear.img_minus_alt',__('hide')).
		
		self::jsVar('dotclear.msg.help',
			__('help')).
		self::jsVar('dotclear.msg.no_selection',
			__('No selection')).
		self::jsVar('dotclear.msg.select_all',
			__('select all')).
		self::jsVar('dotclear.msg.invert_sel',
			__('invert selection')).
		self::jsVar('dotclear.msg.add_another_file',
			__('add another files')).
		self::jsVar('dotclear.msg.website',
			__('Web site:')).
		self::jsVar('dotclear.msg.email',
			__('Email:')).
		self::jsVar('dotclear.msg.ip_address',
			__('IP address:')).
		self::jsVar('dotclear.msg.confirm_delete_posts',
			__("Are you sure you want to delete selected entries?")).
		self::jsVar('dotclear.msg.confirm_delete_post',
			__("Are you sure you want to delete this entry?")).
		self::jsVar('dotclear.msg.confirm_delete_comments',
			__('Are you sure you want to delete selected comments?')).
		self::jsVar('dotclear.msg.confirm_delete_comment',
			__('Are you sure you want to delete this comment?')).
		self::jsVar('dotclear.msg.confirm_delete_user',
			__('Are you sure you want to delete selected users?')).
		self::jsVar('dotclear.msg.confirm_delete_categories',
			__('Are you sure you want to delete the selected categories?')).
		self::jsVar('dotclear.msg.confirm_delete_media',
			__('Are you sure you want to remove this item?')).
		self::jsVar('dotclear.msg.confirm_inflate_current',
			__('Are you sure you want to inflate archive in current directory?')).
		self::jsVar('dotclear.msg.confirm_remove_attachment',
			__('Are you sure you want to remove this attachment?')).
		self::jsVar('dotclear.msg.confirm_delete_plugins',
			__('Are you sure you want to delete selected plugins?')).
		self::jsVar('dotclear.msg.confirm_delete_theme',
			__('Are you sure you want to delete selected theme?')).
		self::jsVar('dotclear.msg.confirm_delete_theme_current',
			__('Are you sure you want to delete your current theme?')).
		self::jsVar('dotclear.msg.cant_delete_default_theme',
			__('You can\'t remove default theme.')).
		self::jsVar('dotclear.msg.zip_file_content',
			__('Zip file content')).
		self::jsVar('dotclear.msg.xhtml_validator',
			__('XHTML markup validator')).
		self::jsVar('dotclear.msg.xhtml_valid',
			__('XHTML content is valid.')).
		self::jsVar('dotclear.msg.xhtml_not_valid',
			__('There are XHTML markup errors.')).
		"\n//]]>\n".
		"</script>\n";
	}
	
	public static function jsLoadIE7()
	{
		return
		'<!--[if lt IE 7]>'."\n".
		self::jsLoad('js/ie7/ie7-standard-p.js').
		'<link rel="stylesheet" type="text/css" href="style/iesucks.css" />'."\n".
		'<![endif]-->'."\n";
	}
	
	public static function jsConfirmClose()
	{
		$args = func_get_args();
		if (count($args) > 0) {
			foreach ($args as $k => $v) {
				$args[$k] = "'".html::escapeJS($v)."'";
			}
			$args = implode(',',$args);
		} else {
			$args = '';
		}
		
		return
		self::jsLoad('js/confirm-close.js').
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		"confirmClosePage = new confirmClose(".$args."); ".
		"confirmClose.prototype.prompt = '".html::escapeJS(__('You have unsaved changes.'))."'; ".
		"\n//]]>\n".
		"</script>\n";
	}
	
	public static function jsPageTabs($default=null)
	{
		if ($default) {
			$default = "'".html::escapeJS($default)."'";
		}
		
		return
		self::jsLoad('js/jquery/jquery.pageTabs.js').
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		"\$(function() {\n".
		"	\$.pageTabs(".$default.");\n".
		"});\n".
		"\n//]]>\n".
		"</script>\n";
	}
	
	public static function jsColorPicker()
	{
		return
		'<link rel="stylesheet" type="text/css" href="style/farbtastic/farbtastic.css" />'."\n".
		self::jsLoad('js/jquery/jquery.farbtastic.js').
		self::jsLoad('js/color-picker.js');
	}
	
	public static function jsDatePicker()
	{
		return
		'<link rel="stylesheet" type="text/css" href="style/date-picker.css" />'."\n".
		self::jsLoad('js/date-picker.js').
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		
		"datePicker.prototype.months[0] = '".html::escapeJS(__('January'))."'; ".
		"datePicker.prototype.months[1] = '".html::escapeJS(__('February'))."'; ".
		"datePicker.prototype.months[2] = '".html::escapeJS(__('March'))."'; ".
		"datePicker.prototype.months[3] = '".html::escapeJS(__('April'))."'; ".
		"datePicker.prototype.months[4] = '".html::escapeJS(__('May'))."'; ".
		"datePicker.prototype.months[5] = '".html::escapeJS(__('June'))."'; ".
		"datePicker.prototype.months[6] = '".html::escapeJS(__('July'))."'; ".
		"datePicker.prototype.months[7] = '".html::escapeJS(__('August'))."'; ".
		"datePicker.prototype.months[8] = '".html::escapeJS(__('September'))."'; ".
		"datePicker.prototype.months[9] = '".html::escapeJS(__('October'))."'; ".
		"datePicker.prototype.months[10] = '".html::escapeJS(__('November'))."'; ".
		"datePicker.prototype.months[11] = '".html::escapeJS(__('December'))."'; ".
	
		"datePicker.prototype.days[0] = '".html::escapeJS(__('Monday'))."'; ".
		"datePicker.prototype.days[1] = '".html::escapeJS(__('Tuesday'))."'; ".
		"datePicker.prototype.days[2] = '".html::escapeJS(__('Wednesday'))."'; ".
		"datePicker.prototype.days[3] = '".html::escapeJS(__('Thursday'))."'; ".
		"datePicker.prototype.days[4] = '".html::escapeJS(__('Friday'))."'; ".
		"datePicker.prototype.days[5] = '".html::escapeJS(__('Saturday'))."'; ".
		"datePicker.prototype.days[6] = '".html::escapeJS(__('Sunday'))."'; ".
		
		"datePicker.prototype.img_src = 'images/date-picker.png'; ".
		
		"datePicker.prototype.close_msg = '".html::escapeJS(__('close'))."'; ".
		"datePicker.prototype.now_msg = '".html::escapeJS(__('now'))."'; ".
		
		"\n//]]>\n".
		"</script>\n";
	}
	
	public static function jsToolBar()
	{
		$res =
		'<link rel="stylesheet" type="text/css" href="style/jsToolBar/jsToolBar.css" />'.
		'<script type="text/javascript" src="js/jsToolBar/jsToolBar.js"></script>';
		
		if (isset($GLOBALS['core']->auth) && $GLOBALS['core']->auth->getOption('enable_wysiwyg')) {
			$res .= '<script type="text/javascript" src="js/jsToolBar/jsToolBar.wysiwyg.js"></script>';
		}
		
		$res .=
		'<script type="text/javascript" src="js/jsToolBar/jsToolBar.dotclear.js"></script>'.
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		"jsToolBar.prototype.dialog_url = 'popup.php'; ".
		"jsToolBar.prototype.iframe_css = '".
			'body{'.
				'font: 12px "DejaVu Sans","Lucida Grande","Lucida Sans Unicode",Arial,sans-serif;'.
				'color : #000;'.
				'background: #f9f9f9;'.
				'margin: 0;'.
				'padding : 2px;'.
				'border: none;'.
				(self::getTextDirection() == 'rtl' ? 'direction:rtl;' : '').
			'}'.
			'pre, code, kbd, samp {'.
				'font-family:"Courier New",Courier,monospace;'.
				'font-size : 1.1em;'.
			'}'.
			'code {'.
				'color : #666;'.
				'font-weight : bold;'.
			'}'.
			'body > p:first-child {'.
				'margin-top: 0;'.
			'}'.
		"'; ".
		"jsToolBar.prototype.base_url = '".html::escapeJS($GLOBALS['core']->blog->host)."'; ".
		"jsToolBar.prototype.switcher_visual_title = '".html::escapeJS(__('visual'))."'; ".
		"jsToolBar.prototype.switcher_source_title = '".html::escapeJS(__('source'))."'; ".
		"jsToolBar.prototype.legend_msg = '".
		html::escapeJS(__('You can use the following shortcuts to format your text.'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.none = '".html::escapeJS(__('-- none --'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.nonebis = '".html::escapeJS(__('-- block format --'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.p = '".html::escapeJS(__('Paragraph'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.h1 = '".html::escapeJS(__('Level 1 header'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.h2 = '".html::escapeJS(__('Level 2 header'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.h3 = '".html::escapeJS(__('Level 3 header'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.h4 = '".html::escapeJS(__('Level 4 header'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.h5 = '".html::escapeJS(__('Level 5 header'))."'; ".
		"jsToolBar.prototype.elements.blocks.options.h6 = '".html::escapeJS(__('Level 6 header'))."'; ".
		"jsToolBar.prototype.elements.strong.title = '".html::escapeJS(__('Strong emphasis'))."'; ".
		"jsToolBar.prototype.elements.em.title = '".html::escapeJS(__('Emphasis'))."'; ".
		"jsToolBar.prototype.elements.ins.title = '".html::escapeJS(__('Inserted'))."'; ".
		"jsToolBar.prototype.elements.del.title = '".html::escapeJS(__('Deleted'))."'; ".
		"jsToolBar.prototype.elements.quote.title = '".html::escapeJS(__('Inline quote'))."'; ".
		"jsToolBar.prototype.elements.code.title = '".html::escapeJS(__('Code'))."'; ".
		"jsToolBar.prototype.elements.br.title = '".html::escapeJS(__('Line break'))."'; ".
		"jsToolBar.prototype.elements.blockquote.title = '".html::escapeJS(__('Blockquote'))."'; ".
		"jsToolBar.prototype.elements.pre.title = '".html::escapeJS(__('Preformated text'))."'; ".
		"jsToolBar.prototype.elements.ul.title = '".html::escapeJS(__('Unordered list'))."'; ".
		"jsToolBar.prototype.elements.ol.title = '".html::escapeJS(__('Ordered list'))."'; ".
		
		"jsToolBar.prototype.elements.link.title = '".html::escapeJS(__('Link'))."'; ".
		"jsToolBar.prototype.elements.link.href_prompt = '".html::escapeJS(__('URL?'))."'; ".
		"jsToolBar.prototype.elements.link.hreflang_prompt = '".html::escapeJS(__('Language?'))."'; ".
		
		"jsToolBar.prototype.elements.img.title = '".html::escapeJS(__('External image'))."'; ".
		"jsToolBar.prototype.elements.img.src_prompt = '".html::escapeJS(__('URL?'))."'; ".
		
		"jsToolBar.prototype.elements.img_select.title = '".html::escapeJS(__('Media chooser'))."'; ".
		"jsToolBar.prototype.elements.post_link.title = '".html::escapeJS(__('Link to an entry'))."'; ";
		
		if (!$GLOBALS['core']->auth->check('media,media_admin',$GLOBALS['core']->blog->id)) {
			$res .= "jsToolBar.prototype.elements.img_select.disabled = true;\n";
		}
		
		$res .=
		"\n//]]>\n".
		"</script>\n";
		
		return $res;
	}
	
	public static function jsToolMan()
	{
		return
		'<script type="text/javascript" src="js/tool-man/core.js"></script>'.
		'<script type="text/javascript" src="js/tool-man/events.js"></script>'.
		'<script type="text/javascript" src="js/tool-man/css.js"></script>'.
		'<script type="text/javascript" src="js/tool-man/coordinates.js"></script>'.
		'<script type="text/javascript" src="js/tool-man/drag.js"></script>'.
		'<script type="text/javascript" src="js/tool-man/dragsort.js"></script>'.
		'<script type="text/javascript" src="js/dragsort-tablerows.js"></script>';
	}
	
	public static function jsMediaObjects()
	{
		$blog_url = $GLOBALS['core']->blog->getQmarkURL();
		
		$mp3_player = $blog_url.'pf=player_mp3.swf';
		$flv_player = $blog_url.'pf=player_flv.swf';
		
		return
		'<script type="text/javascript">'."\n".
		"//<![CDATA[\n".
		
		"dotclear.mp3_player = {};\n".
		"dotclear.flv_player = {};\n".
		self::jsVar('dotclear.mp3_player.url',$mp3_player).
		self::jsVar('dotclear.mp3_player.tpl',dcMedia::mp3player('%URL%','%PLAYER%')).
		self::jsVar('dotclear.flv_player.url',$flv_player).
		self::jsVar('dotclear.flv_player.tpl',dcMedia::flvplayer('%URL%','%PLAYER%')).
		
		"\n//]]>\n".
		"</script>\n";
	}
}
?>