<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('usage,contentadmin');

$href = !empty($_GET['href']) ? $_GET['href'] : '';
$title = !empty($_GET['title']) ? $_GET['title'] : '';
$hreflang = !empty($_GET['hreflang']) ? $_GET['hreflang'] : '';

dcPage::openPopup(__('Add a link'),dcPage::jsLoad('js/jsToolBar/popup_link.js'));

echo '<h2>'.__('Add a link').'</h2>';

# Languages combo
# Languages combo
$rs = $core->blog->getLangs(array('order'=>'asc'));
$all_langs = l10n::getISOcodes();
$lang_combo = array('' => '', __('Most used') => array(), __('Available') => l10n::getISOcodes(1));
while ($rs->fetch()) {
	if (isset($all_langs[$rs->post_lang])) {
		$lang_combo[__('Most used')][$all_langs[$rs->post_lang]] = $rs->post_lang;
		unset($lang_combo[__('Available')][$all_langs[$rs->post_lang]]);
	} else {
		$lang_combo[__('Most used')][$rs->post_lang] = $rs->post_lang;
	}
}
unset($all_langs);
unset($rs);

echo
'<form id="link-insert-form" action="#" method="get">'.
'<p><label class="required" title="'.__('Required field').'">'.__('Link URL:').' '.
form::field('href',35,512,html::escapeHTML($href)).'</label></p>'.
'<p><label>'.__('Link language:').' '.
form::combo('hreflang',$lang_combo,$hreflang).
'</label></p>'.
'</form>'.

'<p><a class="button" href="#" id="link-insert-cancel">'.__('cancel').'</a> - '.
'<strong><a class="button" href="#" id="link-insert-ok">'.__('insert').'</a></strong></p>';

dcPage::closePopup();
?>