<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!empty($_GET['pf'])) {
	require dirname(__FILE__).'/../inc/load_plugin_file.php';
	exit;
}

require dirname(__FILE__).'/../inc/admin/prepend.php';

if (!empty($_GET['default_blog'])) {
	try {
		$core->setUserDefaultBlog($core->auth->userID(),$core->blog->id);
		http::redirect('index.php');
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}

dcPage::check('usage,contentadmin');

# Logout
if (!empty($_GET['logout'])) {
	$core->session->destroy();
	if (isset($_COOKIE['dc_admin'])) {
		unset($_COOKIE['dc_admin']);
		setcookie('dc_admin',false,-600,'','',DC_ADMIN_SSL);
	}
	http::redirect('auth.php');
	exit;
}

# Plugin install
$plugins_install = $core->plugins->installModules();

# Dashboard icons
$__dashboard_icons = new arrayObject();

$post_count = $core->blog->getPosts(array(),true)->f(0);
$str_entries = ($post_count > 1) ? __('%d entries') : __('%d entry');

$comment_count = $core->blog->getComments(array(),true)->f(0);
$str_comments = ($comment_count > 1) ? __('%d comments') : __('%d comment');

$__dashboard_icons['new_post'] = new arrayObject(array(__('New entry'),'post.php','images/menu/edit-b.png'));
$__dashboard_icons['posts'] = new arrayObject(array(sprintf($str_entries,$post_count),'posts.php','images/menu/entries-b.png'));
$__dashboard_icons['comments'] = new arrayObject(array(sprintf($str_comments,$comment_count),'comments.php','images/menu/comments-b.png'));
$__dashboard_icons['prefs'] = new arrayObject(array(__('User preferences'),'preferences.php','images/menu/user-pref-b.png'));

if ($core->auth->check('admin',$core->blog->id))
{
	$__dashboard_icons['blog_pref'] = new arrayObject(array(__('Blog settings'),'blog_pref.php','images/menu/blog-pref-b.png'));
	$__dashboard_icons['blog_theme'] = new arrayObject(array(__('Theme settings'),'blog_theme.php','images/menu/blog-theme-b.png'));
}

$core->callBehavior('adminDashboardIcons', $core, $__dashboard_icons);


# Latest news for dashboard
$__dashboard_items = new arrayObject(array(new arrayObject,new arrayObject));

try
{
	if (empty($__resources['rss_news'])) {
		throw new Exception('No feed');
	}
	
	$feed_reader = new feedReader;
	$feed_reader->setCacheDir(DC_TPL_CACHE);
	$feed_reader->setTimeout(2);
	$feed_reader->setUserAgent('Dotclear - http://www.dotclear.net/');
	$feed = $feed_reader->parse($__resources['rss_news']);
	if ($feed)
	{
		$latest_news = '<h3>'.__('Latest news').'</h3><ul>';
		$i = 1;
		foreach ($feed->items as $item) {
			$latest_news .= '<li><a href="'.$item->link.'">'.$item->title.'</a></li>';
			$i++;
			if ($i > 5) { break; }
		}
		$latest_news .= '</ul>';
		$__dashboard_items[0][] = $latest_news;
	}
}
catch (Exception $e) {}


# Documentation links
if (!empty($__resources['doc']))
{
	$doc_links = '<h3>'.__('Documentation').'</h3><ul>';
	
	foreach ($__resources['doc'] as $k => $v) {
		$doc_links .= '<li><a href="'.$v.'">'.$k.'</a></li>';
	}
	
	$doc_links .= '</ul>';
	$__dashboard_items[1][] = $doc_links;
}

$core->callBehavior('adminDashboardItems', $core, $__dashboard_items);

/* DISPLAY
-------------------------------------------------------- */
dcPage::open(__('Dashboard'));

echo '<h2>'.html::escapeHTML($core->blog->name).' &gt; '.__('Dashboard').'</h2>';

if ($core->auth->getInfo('user_default_blog') != $core->blog->id
&& count($core->blogs) > 1) {
	echo
	'<p id="default-blog"><a href="index.php?default_blog=1">'.
	__('Make this blog my default blog').'</a></p>';
}

if ($core->blog->status == 0) {
	echo '<p class="static-msg">'.__('This blog is offline').'</p>';
} elseif ($core->blog->status == -1) {
	echo '<p class="static-msg">'.__('This blog is removed').'</p>';
}

if (!DC_ADMIN_URL) {
	echo
	'<p class="static-msg">'.
	__('DC_ADMIN_URL is not defined, you should edit your configuration file.').
	'</p>';
}

# Plugins install messages
if (!empty($plugins_install['success']))
{
	echo '<div class="static-msg">'.__('Following plugins have been installed:').'<ul>';
	foreach ($plugins_install['success'] as $k => $v) {
		echo '<li>'.$k.'</li>';
	}
	echo '</ul></div>';
}
if (!empty($plugins_install['failure']))
{
	echo '<div class="error">'.__('Following plugins have not been installed:').'<ul>';
	foreach ($plugins_install['failure'] as $k => $v) {
		echo '<li>'.$k.' ('.$v.')</li>';
	}
	echo '</ul></div>';
}

# Dashboard icons
echo '<div id="dashboard-icons">';
foreach ($__dashboard_icons as $i)
{
	echo
	'<p><a href="'.$i[1].'"><img src="'.$i[2].'" alt="'.$i[0].'" /></a>'.
	'<span><a href="'.$i[1].'">'.$i[0].'</a></span></p>';
}
echo '</div>';

# Dashboard columns
echo
'<div id="dashboard" class="two-cols">'.
'<div class="col">';

foreach ($__dashboard_items[0] as $v) {
	echo $v;
}

echo
'</div>'.
'<div class="col">';

foreach ($__dashboard_items[1] as $v) {
	echo $v;
}

echo '</div></div>';

?>
<?php dcPage::close(); ?>