<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('admin');

# Loading themes
$core->themes = new dcModules($core);
$core->themes->loadModules($core->blog->themes_path,null);

# Theme screenshot
if (!empty($_GET['shot']) && $core->themes->moduleExists($_GET['shot']))
{
	if (empty($_GET['src'])) {
		$f = $core->blog->themes_path.'/'.$_GET['shot'].'/screenshot.jpg';
	} else {
		$f = $core->blog->themes_path.'/'.$_GET['shot'].'/'.path::clean($_GET['src']);
	}
	
	$f = path::real($f);
	
	if (!file_exists($f)) {
		$f = dirname(__FILE__).'/images/noscreenshot.png';
	}
	
	http::cache(array_merge(array($f),get_included_files()));
	
	header('Content-Type: '.files::getMimeType($f));
	header('Content-Length: '.filesize($f));
	readfile($f);
	
	exit;
}

$can_install = $core->auth->isSuperAdmin();
$is_writable = is_dir($core->blog->themes_path) && is_writable($core->blog->themes_path);
$default_tab = 'themes-list';

# Selecting theme
if (!empty($_POST['theme']) && !empty($_POST['select']) && empty($_REQUEST['conf']))
{
	$core->blog->settings->setNameSpace('system');
	$core->blog->settings->put('theme',$_POST['theme']);
	$core->blog->triggerBlog();
	http::redirect('blog_theme.php?upd=1');
}

if ($can_install && !empty($_POST['theme']) && !empty($_POST['remove']) && empty($_REQUEST['conf']))
{
	try
	{
		if ($_POST['theme'] == 'default') {
			throw new Exception(__('You can\'t remove default theme.'));
		}
		
		if (!$core->themes->moduleExists($_POST['theme'])) {
			throw new Exception(__('Theme does not exist.'));
		}
		
		$theme = $core->themes->getModules($_POST['theme']);
		
		# --BEHAVIOR-- themeBeforeDelete
		$core->callBehavior('themeBeforeDelete',$theme);
		
		$core->themes->deleteModule($_POST['theme']);
		
		# --BEHAVIOR-- themeAfterDelete
		$core->callBehavior('themeAfterDelete',$theme);
		
		http::redirect('blog_theme.php?del=1');
	}
	catch (Exception $e)
	{
		$core->error->add(
			sprintf(__('An error occured while deleting %s theme:'),html::escapeHTML($plugin['name'])).
			' '.$e->getMessage()
		);
	}
}

# Theme upload
if ($can_install && $is_writable && ((!empty($_POST['upload_pkg']) && !empty($_FILES['pkg_file'])) ||
	(!empty($_POST['fetch_pkg']) && !empty($_POST['pkg_url']))))
{
	try
	{
		if (empty($_POST['your_pwd']) || !$core->auth->checkPassword(crypt::hmac(DC_MASTER_KEY,$_POST['your_pwd']))) {
			throw new Exception(__('Password verification failed'));
		}
		
		if (!empty($_POST['upload_pkg']))
		{
			files::uploadStatus($_FILES['pkg_file']);
			
			$dest = $core->blog->themes_path.'/'.$_FILES['pkg_file']['name'];
			if (!move_uploaded_file($_FILES['pkg_file']['tmp_name'],$dest)) {
				throw new Exception(__('Unable to move uploaded file.'));
			}
		}
		else
		{
			$url = html::escapeHTML($_POST['pkg_url']);
			$dest = $core->blog->themes_path.'/'.basename($url);
			
			try
			{
				$client = netHttp::initClient($url,$path,10);
				$client->setUserAgent('Dotclear - http://www.dotclear.net/');
				$client->useGzip(false);
				$client->setPersistReferers(false);
				$client->setOutput($dest);
				$client->get($path);
			}
			catch( Exception $e)
			{
				throw new Exception(__('An error occured while downloading the file.'));
			}
			
			unset($client);
		}
		
		$ret_code = dcModules::installPackage($dest,$core->themes);
		http::redirect('blog_theme.php?added='.$ret_code);
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
		$default_tab = 'add-theme';
	}
}

$theme_conf_mode = false;
if (!empty($_REQUEST['conf']))
{
	$theme_conf_file = path::real($core->blog->themes_path.'/'.$core->blog->settings->theme).'/_config.php';
	if (file_exists($theme_conf_file)) {
		$theme_conf_mode = true;
	}
}

function display_theme_details($id,$details,$current)
{
	global $core;
	
	$screenshot = 'images/noscreenshot.png';
	if (file_exists($core->blog->themes_path.'/'.$id.'/screenshot.jpg')) {
		$screenshot = 'blog_theme.php?shot='.rawurlencode($id);
	}
	
	$radio_id = 'theme_'.html::escapeHTML($id);
	
	$res =
	'<div'.($current ? ' class="current-theme"' : '').'>'.
	'<h3>'.form::radio(array('theme',$radio_id),html::escapeHTML($id),$current).' '.
	'<label class="classic" for="'.$radio_id.'">'.
	html::escapeHTML($details['name']).'</label></h3>'.
	'<p>'.sprintf(__('by %s'),html::escapeHTML($details['author'])).'</p>';
	
	if ($current && file_exists(path::real($core->blog->themes_path.'/'.$core->blog->settings->theme).'/_config.php'))
	{
		$res .= '<p><a href="blog_theme.php?conf=1" class="button">'.__('Theme configuration').'</a></p>';
	}
	if ($current) {
		$res .= $core->callBehavior('adminCurrentThemeDetails',$core,$id,$details);
	}
	
	$res .=
	'<img src="'.$screenshot.'" alt="" />'.
	'</div>';
	
	return $res;
}

dcPage::open(__('Blog themes'),
	dcPage::jsLoad('js/_blog_theme.js').
	dcPage::jsPageTabs($default_tab).
	dcPage::jsColorPicker()
);

if (!$theme_conf_mode)
{
	echo
	'<h2>'.html::escapeHTML($core->blog->name).' &gt; '.__('Theme settings').'</h2>';
	
	if (!empty($_GET['upd'])) {
		echo '<p class="message">'.__('Theme has been successfully changed.').'</p>';
	}
	
	if (!empty($_GET['added'])) {
		echo '<p class="message">'.
		($_GET['added'] == 2 ? __('Theme has been successfully upgraded') : __('Theme has been successfully installed.')).
		'</p>';
	}
	
	if (!empty($_GET['del'])) {
		echo '<p class="message">'.__('Theme has been successfully deleted.').'</p>';
	}
	
	# Themes list
	echo
	'<div class="multi-part" id="themes-list" title="'.__('Themes').'">'.
	'<form action="blog_theme.php" method="post" id="themes-form">'.
	'<div id="themes">';
	
	$themes = $core->themes->getModules();
	
	if (isset($themes[$core->blog->settings->theme]))
	{
		echo '<h3>'.__('Current theme').'</h3>';
		echo display_theme_details($core->blog->settings->theme,$themes[$core->blog->settings->theme],true);
	}
	
	echo '<h3>'.__('Available themes').'</h3>';
	foreach ($themes as $k => $v)
	{
		$current_theme = $core->blog->settings->theme == $k;
		
		if ($current_theme) {
			continue;
		}
		
		echo display_theme_details($k,$v,false);
	}
	
	echo '</div>';
	
	echo
	'<div class="two-cols clear">'.
	$core->formNonce().
	'<p class="col"><input type="submit" name="select" value="'.__('use selected theme').'" /></p>';
	
	if ($can_install) {
		echo '<p class="col right"><input type="submit" name="remove" value="'.__('delete selected theme').'" /></p>';
	}
	
	echo
	'</div>'.
	'</form>'.
	'</div>';
	
	# Add a new theme
	if ($can_install)
	{
		echo
		'<div class="multi-part" id="add-theme" title="'.__('Install or upgrade a theme').'">';
		
		if ($is_writable)
		{
			echo '<p>'.__('You can install themes by uploading or downloading zip files.').'</p>';
			
			# 'Upload theme' form
			echo
			'<form method="post" action="blog_theme.php" id="uploadpkg" enctype="multipart/form-data">'.
			'<fieldset>'.
			'<legend>'.__('Upload a zip file').'</legend>'.
			'<p class="field"><label class=" classic required" title="'.__('Required field').'">'.__('Theme zip file:').' '.
			'<input type="file" name="pkg_file" /></label></p>'.
			'<p class="field"><label class="classic required" title="'.__('Required field').'">'.__('Your password:').' '.
			form::password(array('your_pwd'),20,255).'</label></p>'.
			'<input type="submit" name="upload_pkg" value="'.__('Upload theme').'" />'.
			$core->formNonce().
			'</fieldset>'.
			'</form>';
			
			# 'Fetch theme' form
			echo
			'<form method="post" action="blog_theme.php" id="fetchpkg">'.
			'<fieldset>'.
			'<legend>'.__('Download a zip file').'</legend>'.
			'<p class="field"><label class=" classic required" title="'.__('Required field').'">'.__('Theme zip file URL:').' '.
			form::field(array('pkg_url'),40,255).'</label></p>'.
			'<p class="field"><label class="classic required" title="'.__('Required field').'">'.__('Your password:').' '.
			form::password(array('your_pwd'),20,255).'</label></p>'.
			'<input type="submit" name="fetch_pkg" value="'.__('Download theme').'" />'.
			$core->formNonce().
			'</fieldset>'.
			'</form>';
		}
		else
		{
			echo
			'<p class="static-msg">'.
			__('To enable this function, please give write access to your themes directory.').
			'</p>';
		}
		echo '</div>';
	}
}
else
{
	$theme_name = $core->themes->moduleInfo($core->blog->settings->theme,'name');
	echo
	'<h2>'.html::escapeHTML($core->blog->name).
	' &gt; <a href="blog_theme.php">'.__('Theme settings').'</a> &gt; '.__('Theme configuration').'</h2>'.
	'<p><a href="blog_theme.php">'.__('back').'</a></p>';
	
	try
	{
		echo '<form id="theme_config" action="blog_theme.php?conf=1" method="post" enctype="multipart/form-data">';
		
		include $theme_conf_file;
		
		echo
		'<p class="clear"><input type="submit" value="'.__('save').'" />'.
		$core->formNonce().'</p>'.
		'</form>';
	}
	catch (Exception $e)
	{
		echo '<div class="error"><p>'.$e->getMessage().'</p></div>';
	}
}

dcPage::close();
?>