<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class pingsAPI extends xmlrpcClient
{
	public static function doPings($srv_uri,$site_name,$site_url)
	{
		$o = new self($srv_uri);
		$o->timeout = 3;
		
		$rsp = $o->query('weblogUpdates.ping',$site_name,$site_url);
		
		if (isset($rsp['flerror']) && $rsp['flerror']) {
			throw new Exception($rsp['message']);
		}
		
		return true;
	}
}

class pingsBehaviors
{
	public static function pingJS()
	{
		return dcPage::jsLoad('index.php?pf=pings/post.js');
	}
	
	public static function pingsForm(&$post)
	{
		$core =& $GLOBALS['core'];
		if (!$core->blog->settings->pings_active) {
			return;
		}
		
		$pings_uris = @unserialize($core->blog->settings->pings_uris);
		if (empty($pings_uris) || !is_array($pings_uris)) {
			return;
		}
		
		if (!empty($_POST['pings_do']) && is_array($_POST['pings_do'])) {
			$pings_do = $_POST['pings_do'];
		} else {
			$pings_do = array();
		}
		
		echo '<h3 class="ping-services">'.__('Pings:').'</h3>';
		foreach ($pings_uris as $k => $v)
		{
			echo
			'<p class="ping-services"><label class="classic">'.
			form::checkbox(array('pings_do[]'),html::escapeHTML($v),in_array($v,$pings_do)).' '.
			html::escapeHTML($k).'</label></p>';
		}
	}
	
	public static function doPings(&$cur,&$post_id)
	{
		if (empty($_POST['pings_do']) || !is_array($_POST['pings_do'])) {
			return;
		}
		
		$core =& $GLOBALS['core'];
		if (!$core->blog->settings->pings_active) {
			return;
		}
		
		$pings_uris = @unserialize($core->blog->settings->pings_uris);
		if (empty($pings_uris) || !is_array($pings_uris)) {
			return;
		}
		
		foreach ($_POST['pings_do'] as $uri)
		{
			if (in_array($uri,$pings_uris)) {
				try {
					pingsAPI::doPings($uri,$core->blog->name,$core->blog->url);
				} catch (Exception $e) {}
			}
		}
	}
}
?>