<?php
# ***** BEGIN LICENSE BLOCK *****
# This is Antispam, a plugin for DotClear. 
# Copyright (c) 2007 Alain Vagner and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

global $__autoload, $core;

$__autoload['dcSpamFilter'] = dirname(__FILE__).'/inc/class.dc.spamfilter.php';
$__autoload['dcSpamFilters'] = dirname(__FILE__).'/inc/class.dc.spamfilters.php';
$__autoload['dcAntispam'] = dirname(__FILE__).'/inc/lib.dc.antispam.php';
$__autoload['dcAntispamURL'] = dirname(__FILE__).'/inc/lib.dc.antispam.url.php';

$__autoload['dcFilterIP'] = dirname(__FILE__).'/filters/class.dc.filter.ip.php';
$__autoload['dcFilterIpLookup'] = dirname(__FILE__).'/filters/class.dc.filter.iplookup.php';
$__autoload['dcFilterLinksLookup'] = dirname(__FILE__).'/filters/class.dc.filter.linkslookup.php';
$__autoload['dcFilterWords'] = dirname(__FILE__).'/filters/class.dc.filter.words.php';

$core->spamfilters = array('dcFilterIP','dcFilterWords','dcFilterIpLookup','dcFilterLinksLookup');

$core->url->register('spamfeed','spamfeed','^spamfeed/(.+)$',array('dcAntispamURL','spamFeed'));
$core->url->register('hamfeed','hamfeed','^hamfeed/(.+)$',array('dcAntispamURL','hamFeed'));
?>