<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$core->addBehavior('coreBlogGetPosts',array('rsExtendPublic','coreBlogGetPosts'));
$core->addBehavior('coreBlogGetComments',array('rsExtendPublic','coreBlogGetComments'));

class rsExtendPublic
{
	public static function coreBlogGetPosts(&$rs)
	{
		$rs->extend('rsExtPostPublic');
	}
	
	public static function coreBlogGetComments(&$rs)
	{
		$rs->extend('rsExtCommentPublic');
	}
}

class rsExtPostPublic extends rsExtPost
{
	public static function getContent(&$rs,$absolute_urls=false)
	{
		# Not very nice hack but it does the job :)
		if (isset($GLOBALS['_ctx']) && $GLOBALS['_ctx']->short_feed_items === true) {
			$_ctx =& $GLOBALS['_ctx'];
			$c = parent::getContent($rs,$absolute_urls);
			$c = context::remove_html($c);
			$c = context::cut_string($c,350);
			
			$c =
			'<p>'.$c.'... '.
			'<em><a href="'.$rs->getURL().'">'.__('Read').'</em> '.
			html::escapeHTML($rs->post_title).'</a></p>';
			
			return $c;
		}
		
		if ($rs->core->blog->settings->use_smilies)
		{
			return self::smilies(parent::getContent($rs,$absolute_urls),$rs->core->blog);
		}
		
		return parent::getContent($rs,$absolute_urls);
	}
	
	public static function getExcerpt(&$rs,$absolute_urls=false)
	{
		if ($rs->core->blog->settings->use_smilies)
		{
			return self::smilies(parent::getExcerpt($rs,$absolute_urls),$rs->core->blog);
		}
		
		return parent::getExcerpt($rs,$absolute_urls);
	}
	
	protected static function smilies($c,&$blog)
	{
		if (!isset($GLOBALS['__smilies'])) {
			$GLOBALS['__smilies'] = context::getSmilies($blog);
		}
		return context::addSmilies($c);
	}
}

class rsExtCommentPublic extends rsExtComment
{
	public static function getContent(&$rs,$absolute_urls=false)
	{
		if ($rs->core->blog->settings->use_smilies)
		{
			$c = parent::getContent($rs,$absolute_urls);
			
			if (!isset($GLOBALS['__smilies'])) {
				$GLOBALS['__smilies'] = context::getSmilies($rs->core->blog);
			}
			return context::addSmilies($c);
		}
		
		return parent::getContent($rs,$absolute_urls);
	}
}
?>