<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('usage,contentadmin');

$post_id = !empty($_REQUEST['post_id']) ? (integer) $_REQUEST['post_id'] : null;
$media_id = !empty($_REQUEST['media_id']) ? (integer) $_REQUEST['media_id'] : null;

$params['post_id'] = $post_id;

if ($post_id && $media_id && !empty($_POST['attach']))
{
	$core->media = new dcMedia($core);
	$core->media->addPostMedia($post_id,$media_id);
	http::redirect('post.php?id='.$post_id.'&attached=1');
}

try {
	$core->media = new dcMedia($core);
	$f = $core->media->getPostMedia($post_id,$media_id);
	if (empty($f)) {
		$post_id = $media_id = null;
		throw new Exception(__('This attachment does not exist'));
	}
	$f = $f[0];
} catch (Exception $e) {
	$core->error->add($e->getMessage());
}

# Remove a media from en
if (($post_id && $media_id) || $core->error->flag())
{
	if (!empty($_POST['remove']))
	{
		$core->media->removePostMedia($post_id,$media_id);
		http::redirect('post.php?id='.$post_id.'&rmattach=1');
	}
	elseif (isset($_POST['post_id'])) {
		http::redirect('post.php?id='.$post_id);
	}
	
	if (!empty($_GET['remove']))
	{
		dcPage::open(__('Remove attachment'));
		
		echo '<h2>'.__('Attachment').' &gt; '.__('confirm removal').'</h2>';
		
		echo
		'<form action="post_media.php" method="post">'.
		'<p>'.__('Are you sure you want to remove this attachment?').'</p>'.
		'<p><input type="submit" value="'.__('cancel').'" /> '.
		' &nbsp; <input type="submit" name="remove" value="'.__('yes').'" />'.
		form::hidden('post_id',$post_id).
		form::hidden('media_id',$media_id).
		$core->formNonce().'</p>'.
		'</form>';
		
		dcPage::close();
		exit;
	}
}
?>