<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

function dcSystemCheck(&$con,&$err)
{
	$err = array();
	
	if (version_compare(phpversion(),'5.0','<')) {
		$err[] = sprintf(__('PHP version is %s (5.0 or earlier needed).'),phpversion());
	}
	
	if (!function_exists('mb_detect_encoding')) {
		$err[] = __('Multibyte string module (mbstring) is not available.');
	}
	
	if (!function_exists('iconv')) {
		$err[] = __('Iconv module is not available.');
	}
	
	if (!function_exists('ob_start')) {
		$err[] = __('Output control functions are not available.');
	}
	
	if (!function_exists('simplexml_load_string')) {
		$err[] = __('SimpleXML module is not available.');
	}
	
	if (!function_exists('dom_import_simplexml')) {
		$err[] = __('DOM XML module is not available.');
	}
	
	if (!@preg_match("/\xf8\xa1\xa1\xa1\xa1/u", "\xf8\xa1\xa1\xa1\xa1")) {
		$err[] = __('PCRE engine does not support UTF-8 strings.');
	}
	
	if (!function_exists("spl_classes")) {
		$err[] = __('SPL module is not available.');
	}
	
	if ($con->driver() == 'mysql')
	{
		if (version_compare($con->version(),'4.1','<'))
		{
			$err[] = sprintf(__('MySQL version is %s (4.1 or earlier needed).'),$con->version());
		}
		else
		{
			$rs = $con->select('SHOW ENGINES');
			$innodb = false;
			while ($rs->fetch()) {
				if (strtolower($rs->f(0)) == 'innodb' && strtolower($rs->f(1)) != 'disabled' && strtolower($rs->f(1)) != 'no') {
					$innodb = true;
					break;
				}
			}
			
			if (!$innodb) {
				$err[] = __('MySQL InnoDB engine is not available.');
			}
		}
	}
	elseif ($con->driver() == 'pgsql')
	{
		if (version_compare($con->version(),'8.0','<'))
		{
			$err[] = sprintf(__('PostgreSQL version is %s (8.0 or earlier needed).'),$con->version());
		}
	}
	
	return count($err) == 0;
}
?>
