<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('categories');

$cat_id = '';
$cat_title = '';
$cat_url = '';
$cat_desc = '';
$cat_position = '';

# Getting existing category
if (!empty($_REQUEST['id']))
{
	try {
		$rs = $core->blog->getCategory($_REQUEST['id']);
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
	
	if (!$core->error->flag() && !$rs->isEmpty())
	{
		$cat_id = $rs->cat_id;
		$cat_title = $rs->cat_title;
		$cat_url = $rs->cat_url;
		$cat_desc = $rs->cat_desc;
		$cat_position = $rs->cat_position;
	}
}

# Remove category
if (!empty($_POST['id']) && $cat_id && !empty($_POST['delete']))
{
	try {
		$core->blog->delCategory($_POST['id']);
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
	
	if (!$core->error->flag()) {
		http::redirect('categories.php');
	}
}

# Create or update a category
if (!empty($_POST))
{
	$cur = $core->con->openCursor($core->prefix.'category');
	
	$cur->cat_title = $cat_title = $_POST['cat_title'];
	
	if (isset($_POST['cat_desc'])) {
		$cur->cat_desc = $cat_desc = $_POST['cat_desc'];
	}
	
	if (isset($_POST['cat_url'])) {
		$cur->cat_url = $cat_url = $_POST['cat_url'];
	} else {
		$cur->cat_url = $cat_url;
	}
	
	# Update category
	if ($cat_id)
	{
		try {
			$core->blog->updCategory($_POST['id'],$cur);
			http::redirect('category.php?id='.$_POST['id'].'&upd=1');
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
	}
	# Create category
	else
	{
		try {
			$id = $core->blog->addCategory($cur);
			http::redirect('categories.php?add=1');
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
	}
}



$title = $cat_id ? __('Edit category') : __('New category');

dcPage::open($title,
	dcPage::jsConfirmClose('category-form').	
	dcPage::jsToolBar().
	dcPage::jsLoad('js/_category.js')
);

if (!empty($_GET['upd'])) {
		echo '<p class="message">'.__('Category has been successfully updated.').'</p>';
}

echo
'<h2>'.html::escapeHTML($core->blog->name).' &gt; <a href="categories.php">'.
__('Categories').'</a> &gt; '.$title.'</h2>'.

'<form action="category.php" method="post" id="category-form">'.
'<fieldset class="constrained">'.
'<p><label class="required" title="'.__('Required field').'">'.__('Title:').' '.
dcPage::help('categories','cat_title').
form::field('cat_title',20,255,html::escapeHTML($cat_title),'',2).
'</label></p>'.

'<div class="lockable">'.
'<p><label>'.__('URL:').' '.dcPage::help('categories','cat_url').
form::field('cat_url',20,255,html::escapeHTML($cat_url),'',3).
'</label></p>'.
'<p class="form-note warn" id="note-cat-url">'.
__('Warning: If you set the URL manually, it may conflict with another category.').'</p>'.
'</div>'.

'<p class="area"><label for="cat_desc">'.__('Description:').
dcPage::help('categories','cat_url').'</label> '.
form::textarea('cat_desc',50,8,html::escapeHTML($cat_desc),'',4).
'</p>'.

'<p><input type="submit" accesskey="s" value="'.__('Save').'" tabindex="5" />'.
($cat_id ? form::hidden('id',$cat_id) : '').
'</p>'.
'</fieldset>'.
'</form>';

dcPage::close();
?>