<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::checkSuper();

$blog_id = '';
$blog_url = '';
$blog_name = '';
$blog_desc = '';

# Create a blog
if (!isset($_POST['id']) && !empty($_POST['blog_id']))
{
	$cur = $core->con->openCursor($core->prefix.'blog');
	$blog_id = $cur->blog_id = $_POST['blog_id'];
	$blog_url = $cur->blog_url = $_POST['blog_url'];
	$blog_name = $cur->blog_name = $_POST['blog_name'];
	$blog_desc = $cur->blog_desc = $_POST['blog_desc'];
	
	try {
		$core->addBlog($cur);
		
		# Default settings and override some
		$core->blogDefaults($cur->blog_id);
		$blog_settings = new dcSettings($core,$cur->blog_id);
		$blog_settings->setNameSpace('system');
		$blog_settings->put('lang',$core->auth->getInfo('user_lang'));
		$blog_settings->put('blog_timezone',$core->auth->getInfo('user_tz'));
		
		if (substr($blog_url,-1) == '?') {
			$blog_settings->put('url_scan','query_string');
		} else {
			$blog_settings->put('url_scan','path_info');
		}
		
		http::redirect('blog.php?id='.$cur->blog_id.'&add=1');
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}

if (!empty($_REQUEST['id']))
{
	$edit_blog_mode = true;
	include dirname(__FILE__).'/blog_pref.php';
}
else
{
	dcPage::open(__('New blog'),dcPage::jsConfirmClose('blog-form'));
	
	echo
	'<h2><a href="blogs.php">'.__('Blogs').'</a> &gt; '.__('New blog').'</h2>'.
	
	'<form action="blog.php" method="post" id="blog-form">'.
	
	'<fieldset><legend>'.__('Blog details').'</legend>'.
	'<p><label class="required" title="'.__('Required field').'">'.__('Blog ID:').' '.
	form::field('blog_id',30,32,html::escapeHTML($blog_id)).'</label></p>'.
	'<p class="form-note">'.__('At least 2 characters using letters, numbers or symbols.').'</p>'.
	
	'<p><label class="required" title="'.__('Required field').'">'.__('Blog name:').' '.
	form::field('blog_name',30,255,html::escapeHTML($blog_name)).'</label></p>'.
	
	'<p><label class="required" title="'.__('Required field').'">'.__('Blog URL:').' '.
	form::field('blog_url',30,255,html::escapeHTML($blog_url)).'</label></p>'.
	
	'<p class="area"><label for="blog_desc">'.__('Blog description:').'</label> '.
	form::textarea('blog_desc',60,5,html::escapeHTML($blog_desc)).'</p>'.
	'</fieldset>'.
	
	'<p><input type="submit" accesskey="s" value="'.__('save').'" /></p>'.
	'</form>';
	
	dcPage::close();
}
?>