<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2006 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class akismet extends netHttp
{
	protected $base_host = 'rest.akismet.com';
	protected $ak_host = '';
	protected $ak_version = '1.1';
	protected $ak_path = '/%s/%s';
	
	protected $ak_key = null;
	protected $blog_url;
	
	protected $timeout = 3;
	
	public function __construct($blog_url,$api_key)
	{
		$this->blog_url = $blog_url;
		$this->ak_key = $api_key;
		
		$this->ak_path = sprintf($this->ak_path,$this->ak_version,'%s');
		$this->ak_host = $this->ak_key.'.'.$this->base_host;
		
		parent::__construct($this->ak_host,80);
	}
	
	public function verify()
	{
		$this->host = $this->base_host;
		$path = sprintf($this->ak_path,'verify-key');
		
		$data = array(
			'key' => $this->ak_key,
			'blog' => $this->blog_url
		);
		
		if ($this->post($path,$data,'UTF-8'))
		{
			return $this->getContent() == 'valid';
		}
		
		return false;
	}
	
	public function comment_check($permalink,$type,$author,$email,$url,$content)
	{
		$info_ignore = array('HTTP_COOKIE');
		$info = array();
		
		foreach ($_SERVER as $k => $v) {
			if (strpos($k,'HTTP_') === 0 && !in_array($k,$info_ignore)) {
				$info[$k] = $v;
			}
		}
		
		return $this->callFunc('comment-check',$permalink,$type,$author,$email,$url,$content,$info);
	}
	
	public function submit_spam($permalink,$type,$author,$email,$url,$content)
	{
		$this->callFunc('submit-spam',$permalink,$type,$author,$email,$url,$content);
		return true;
	}
	
	public function submit_ham($permalink,$type,$author,$email,$url,$content)
	{
		$this->callFunc('submit-ham',$permalink,$type,$author,$email,$url,$content);
		return true;
	}
	
	protected function callFunc($function,$permalink,$type,$author,$email,$url,$content,$info=array())
	{
		$ua = isset($info['HTTP_USER_AGENT']) ? $info['HTTP_USER_AGENT'] : '';
		$referer = isset($info['HTTP_REFERER']) ? $info['HTTP_REFERER'] : '';
		
		# Prepare comment data
		$data = array(
			'blog' => $this->blog_url,
			'user_ip' => http::realIP(),
			'user_agent' => $ua,
			'referrer' => $referer,
			'permalink' => $permalink,
			'comment_type' => $type,
			'comment_author' => $author,
			'comment_author_email' => $email,
			'comment_author_url' => $url,
			'comment_content' => $content
		);
		
		$data = array_merge($data,$info);
		
		$this->host = $this->ak_host;
		$path = sprintf($this->ak_path,$function);
		
		if (!$this->post($path,$data,'UTF-8')) {
			throw new Exception('HTTP error: '.$this->getError());
		}
		
		return $this->getContent() == 'true';
	}
}
?>