<?php
# ***** BEGIN LICENSE BLOCK *****
# This is spamplemousse, a plugin for DotClear. 
# Copyright (c) 2005 Benoit CLERC, Alain Vagner and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!$core->blog->settings->ak_key || !$core->blog->settings->ak_active) {
	return;
}

$core->addBehavior('publicBeforeCommentCreate',array('akismetBehaviors','checkComment'));
$core->addBehavior('publicBeforeTrackbackCreate',array('akismetBehaviors','checkTrackback'));

class akismetBehaviors
{
	public static function checkComment(&$cur)
	{
		self::check($cur,'comment');
	}
	
	public static function checkTrackback(&$cur)
	{
		self::check($cur,'trackback');
	}
	
	protected static function check(&$cur,$type)
	{
		if ($cur->comment_status == -2) return;
		
		$core = $GLOBALS['core'];
		
		$ak = new akismet($core->blog->url,$core->blog->settings->ak_key);
		
		try
		{
			if ($ak->verify())
			{
				$post = $core->blog->getPosts(array('post_id' => $cur->post_id));
				
				$c = $ak->comment_check(
					$post->getURL(),
					$type,
					$cur->comment_author,
					$cur->comment_email,
					$cur->comment_site,
					$cur->comment_content
				);
				
				if ($c) # This is spam
				{
					$cur->comment_spam_status = 'Blocked by akismet';
					$cur->comment_status = -2;
				}
			}
		} catch (Exception $e) { /* If http or akismet is dead, we don't need to know it */ }
	}
}

?>