<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

/*== DC_DEBUG ==
ini_set('display_errors',true);
error_reporting(E_ALL | E_STRICT);
define('DC_DEBUG',true);
//*/

if (!defined('DC_DEBUG')) {
	define('DC_DEBUG',false);
}

/* ------------------------------------------------------------------------------------------- */
#  ClearBricks and DotClear classes auto-loader
if (@is_dir('/usr/lib/clearbricks')) {
	define('CLEARBRICKS_PATH','/usr/lib/clearbricks');
} elseif (is_dir(dirname(__FILE__).'/clearbricks')) {
	define('CLEARBRICKS_PATH',dirname(__FILE__).'/clearbricks');
} elseif (isset($_SERVER['CLEARBRICKS_PATH']) && is_dir($_SERVER['CLEARBRICKS_PATH'])) {
	define('CLEARBRICKS_PATH',$_SERVER['CLEARBRICKS_PATH']);
}

if (!defined('CLEARBRICKS_PATH') || !is_dir(CLEARBRICKS_PATH)) {
	exit('No clearbricks path defined');
}

require CLEARBRICKS_PATH.'/_common.php';
$__autoload['dcCore']				= dirname(__FILE__).'/core/class.dc.core.php';
$__autoload['dcAuth']				= dirname(__FILE__).'/core/class.dc.auth.php';
$__autoload['dcBlog']				= dirname(__FILE__).'/core/class.dc.blog.php';
$__autoload['dcError']				= dirname(__FILE__).'/core/class.dc.error.php';
$__autoload['dcMedia']				= dirname(__FILE__).'/core/class.dc.media.php';
$__autoload['dcModules']				= dirname(__FILE__).'/core/class.dc.modules.php';
$__autoload['dcRestServer']			= dirname(__FILE__).'/core/class.dc.rest.php';
$__autoload['dcSettings']			= dirname(__FILE__).'/core/class.dc.settings.php';
$__autoload['dcTrackback']			= dirname(__FILE__).'/core/class.dc.trackback.php';
$__autoload['dcUtils']				= dirname(__FILE__).'/core/class.dc.utils.php';
$__autoload['dcXmlRpc']				= dirname(__FILE__).'/core/class.dc.xmlrpc.php';

$__autoload['rsExtPost']				= dirname(__FILE__).'/core/class.dc.rs.extensions.php';
$__autoload['rsExtComment']			= dirname(__FILE__).'/core/class.dc.rs.extensions.php';
$__autoload['rsExtDates']			= dirname(__FILE__).'/core/class.dc.rs.extensions.php';
$__autoload['rsExtUser']				= dirname(__FILE__).'/core/class.dc.rs.extensions.php';

$__autoload['dcMenu']				= dirname(__FILE__).'/admin/class.dc.menu.php';
$__autoload['dcPage']				= dirname(__FILE__).'/admin/lib.dc.page.php';
$__autoload['adminGenericList']		= dirname(__FILE__).'/admin/lib.pager.php';
$__autoload['adminPostList']			= dirname(__FILE__).'/admin/lib.pager.php';
$__autoload['adminCommentList']		= dirname(__FILE__).'/admin/lib.pager.php';
$__autoload['adminUserList']			= dirname(__FILE__).'/admin/lib.pager.php';

$__autoload['dcTemplate']			= dirname(__FILE__).'/public/class.dc.template.php';
$__autoload['context']				= dirname(__FILE__).'/public/lib.tpl.context.php';
$__autoload['dcUrlHandlers']			= dirname(__FILE__).'/public/lib.urlhandlers.php';
/* ------------------------------------------------------------------------------------------- */


mb_internal_encoding('UTF-8');

# Setting timezone
dt::setTZ('UTC');

# Disallow every special wrapper
if (function_exists('stream_wrapper_unregister'))
{
	foreach (array('http','https','ftp','ftps','ssh2.shell','ssh2.exec',
	'ssh2.tunnel','ssh2.sftp','ssh2.scp','ogg','expect') as $p) {
		@stream_wrapper_unregister($p);
	}
}

if (isset($_SERVER['DC_RC_PATH'])) {
	define('DC_RC_PATH',$_SERVER['DC_RC_PATH']);
} elseif (isset($_SERVER['REDIRECT_DC_RC_PATH'])) {
	define('DC_RC_PATH',$_SERVER['REDIRECT_DC_RC_PATH']);
} else {
	define('DC_RC_PATH',dirname(__FILE__).'/config.php');
}

if (!is_file(DC_RC_PATH)) {
	trigger_error('Unable to open config file',E_USER_ERROR);
	exit;
}

require DC_RC_PATH;

# Constants
define('DC_ROOT',path::real(dirname(__FILE__).'/..'));
define('DC_VERSION','2.0-beta5');
define('DC_L10N_ROOT',dirname(__FILE__).'/../locales');

if (!defined('DC_VENDOR_NAME')) {
	define('DC_VENDOR_NAME','DotClear');
}

try {
	$core = new dcCore(DC_DBDRIVER,DC_DBHOST,DC_DBNAME,DC_DBUSER,DC_DBPASSWORD,DC_DBPREFIX);
} catch (Exception $e) {
	trigger_error($e->getMessage(),E_USER_ERROR);
	exit;
}

# If we have some __top_behaviors, we load them
if (isset($__top_behaviors) && is_array($__top_behaviors))
{
	foreach ($__top_behaviors as $b) {
		$core->addBehavior($b[0],$b[1]);
	}
	unset($b);
}

http::trimRequest();
try {
	http::unsetGlobals();
} catch (Exception $e) {
	header('Content-Type: text/plain');
	echo $e->getMessage();
	exit;
}

l10n::init();

$core->url->registerDefault(array('dcUrlHandlers','home'));
$core->url->register('lang','','^([a-zA-Z]{2}(?:-[a-z]{2})?(?:/page/[0-9]+)?)$',array('dcUrlHandlers','lang'));
$core->url->register('post','post','^post/(.+)$',array('dcUrlHandlers','post'));
$core->url->register('category','category','^category/(.+)$',array('dcUrlHandlers','category'));
$core->url->register('archive','archive','^archive(/.+)?$',array('dcUrlHandlers','archive'));

$core->url->register('feed','feed','^feed/(.+)$',array('dcUrlHandlers','feed'));
$core->url->register('trackback','trackback','^trackback/(.+)$',array('dcUrlHandlers','trackback'));
$core->url->register('rsd','rsd','^rsd$',array('dcUrlHandlers','rsd'));

# Store upload_max_filesize in bytes
define('DC_MAX_UPLOAD_SIZE',files::str2bytes(ini_get('upload_max_filesize')));

# Shutdown
register_shutdown_function('__shutdown');

function __shutdown()
{
	global $__shutdown;
	if (is_array($__shutdown)) {
		foreach ($__shutdown as $f) {
			if (is_callable($f)) {
				call_user_func($f);
			}
		}
	}
	
	# Explicitly close session before DB connection
	if (session_id()) {
		session_write_close();
	}
	$GLOBALS['core']->con->close();
}
?>