<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

function dotclearUpgrade(&$core)
{
	$upfile = dirname(__FILE__).'/upgrade-'.$core->con->driver().'.xml';
	
	$rs = $core->con->select('SELECT version FROM '.$core->prefix."version WHERE module='core'");
	
	if (version_compare($rs->f(0),DC_VERSION,'<') == 1)
	{
		if (is_readable($upfile))
		{
			$xsql = new xmlsql($core->con,file_get_contents($upfile));
			$xsql->replace('{{PREFIX}}',$core->prefix);
			
			try
			{
				# Database upgrade
				$xsql->execute($rs->f(0));
				
				/* Some other upgrades
				------------------------------------ */
				# Populate media_dir field (since 2.0-beta3.3)
				if (version_compare($rs->f(0),'2.0-beta3.3','<'))
				{
					$strReq = 'SELECT media_id, media_file FROM '.$core->prefix.'media ';
					$rs_m = $core->con->select($strReq);
					while($rs_m->fetch()) {
						$cur = $core->con->openCursor($core->prefix.'media');
						$cur->media_dir = dirname($rs_m->media_file);
						$cur->update('WHERE media_id = '.(integer) $rs_m->media_id);
					}
				}
				
				$cur = $core->con->openCursor($core->prefix.'version');
				$cur->module = 'core';
				$cur->version = (string) DC_VERSION;
				$cur->update("WHERE module='core'");
				$core->blogDefaults();
				return true;
			}
			catch (Exception $e)
			{
				throw new Exception(__('Something went wrong with auto upgrade:').
				' '.$e->getMessage());
			}
		}
	}
}
?>