#!/usr/bin/env php
<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2007 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

try
{
	if (isset($_SERVER['argv'][1])) {
		$dc_conf = $_SERVER['argv'][1];
	} elseif (isset($_SERVER['DC_RC_PATH'])) {
		$dc_conf = realpath($_SERVER['DC_RC_PATH']);
	} else {
		$dc_conf = dirname(__FILE__).'/../config.php';
	}
	
	if (!is_file($dc_conf)) {
		throw new Exception(sprintf('%s is not a file',$dc_conf));
	}
	
	$_SERVER['DC_RC_PATH'] = $dc_conf;
	unset($dc_conf);
	
	require dirname(__FILE__).'/../prepend.php';
	require dirname(__FILE__).'/upgrade.php';
	
	echo "Starting upgrade process\n";
	$core->con->begin();
	try {
		dotclearUpgrade(&$core);
	} catch (Exception $e) {
		$core->con->rollback();
		throw $e;
	}
	$core->con->commit();
	echo "Upgrade process successfully completed\n";
	exit(0);
}
catch (Exception $e)
{
	echo $e->getMessage()."\n";
	exit(1);
}
?>