<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

include dirname(__FILE__).'/_default_widgets.php';
require_once dirname(__FILE__).'/_widgets_functions.php';

$core->tpl->addValue('Widgets',array('publicWidgets','tplWidgets'));

class publicWidgets
{
	public static function tplWidgets($attr)
	{
		$type = isset($attr['type']) ? $attr['type'] : 'nav';
		
		return
		'<?php '.
		"publicWidgets::widgetsHandler('".addslashes($type)."'); ".
		' ?>';
	}
	
	public static function widgetsHandler($type)
	{
		$wtype = 'widgets_'.$type;
		$widgets = $GLOBALS['core']->blog->settings->{$wtype};
		
		if (!$widgets) { // If widgets value is empty, get defaults
			$widgets = self::defaultWidgets($type);
		} else { // Otherwise, load widgets
			$widgets = dcWidgets::load($widgets);
		}
		
		if ($widgets->isEmpty()) { // Widgets are empty, don't show anything
			return;
		}
		
		foreach ($widgets->elements() as $k => $w) {
			echo $w->call($k);
		}
	}
	
	private static function defaultWidgets($type)
	{
		$widgets = new dcWidgets();
		$w = new dcWidgets();
		
		if (isset($GLOBALS['__default_widgets'][$type])) {
			$w = $GLOBALS['__default_widgets'][$type];
		}
		
		return $w;
	}
}
?>