<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2003-2006 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!defined('DC_CONTEXT_ADMIN')) { exit; }

dcPage::check('admin');

$ak_active = $core->blog->settings->ak_active;
$ak_key = $core->blog->settings->ak_key;
$ak_verified = null;

if (isset($_POST['ak_key']))
{
	try
	{
		$ak_active = !empty($_POST['ak_active']);
		$ak_key = $_POST['ak_key'];
		
		$core->blog->settings->setNameSpace('akismet');
		$core->blog->settings->put('ak_active',$ak_active,'boolean');
		$core->blog->settings->put('ak_key',$ak_key,'string');
		
		http::redirect($p_url.'&up=1');
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

if ($core->blog->settings->ak_key && $core->blog->settings->ak_active)
{
	try {
		$ak = new akismet($core->blog->url,$core->blog->settings->ak_key);
		$ak_verified = $ak->verify();
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}
?>
<html>
<head>
  <title><?php echo __('Akismet settings'); ?></title>
</head>

<body>
<?php
echo '<h2>'.html::escapeHTML($core->blog->name).' &gt; '.__('Akismet settings').'</h2>';

echo
'<form action="'.$p_url.'" method="post">'.
'<p><label class="classic">'.
form::checkbox('ak_active',1,$ak_active).' '.
__('Active akismet spam filter').'</label></p>'.
'<p><label class="classic">'.__('Akismet API key:').' '.
form::field('ak_key',12,128,$ak_key).'</label>';

if ($ak_verified !== null) {
	if ($ak_verified) {
		echo ' <img src="images/check-on.png" alt="" /> '.__('API key verified');
	} else {
		echo ' <img src="images/check-off.png" alt="" /> '.__('API key not verified');
	}
}

echo '</p>';

echo
'<p><a href="http://akismet.com/">'.__('Get your own API key').'</a></p>'.
'<p><input type="submit" value="'.__('save').'" /></p>'.
'</form>';
?>
</body>
</html>