<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

/**
@ingroup DC_CORE
@brief Dotclear helper methods

Provides some Dotclear helpers
*/
class dcUtils
{
	/**
	Static function that returns user's common name given to his
	<var>user_id</var>, <var>user_name</var>, <var>user_firstname</var> and
	<var>user_displayname</var>.
	
	@param	user_id			<b>string</b>	User ID
	@param	user_name			<b>string</b>	User's name
	@param	user_firstname		<b>string</b>	User's first name
	@param	user_displayname	<b>string</b>	User's display name
	@return	<b>string</b>
	*/
	public static function getUserCN($user_id, $user_name, $user_firstname, $user_displayname)
	{
		if (!empty($user_displayname)) {
			return $user_displayname;
		}
		
		if (!empty($user_name)) {
			if (!empty($user_firstname)) {
				return $user_firstname.' '.$user_name;
			} else {
				return $user_name;
			}
		} elseif (!empty($user_firstname)) {
			return $user_firstname;
		}
		
		return $user_id;
	}
}

?>