<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

if (!empty($_GET['pf'])) {
	require dirname(__FILE__).'/../inc/load_plugin_file.php';
	exit;
}

$__dashboard_items = array(array(),array());

require dirname(__FILE__).'/../inc/admin/prepend.php';

if (!empty($_GET['default_blog'])) {
	try {
		$core->setUserDefaultBlog($core->auth->userID(),$core->blog->id);
		http::redirect('index.php');
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}

dcPage::check('usage,contentadmin');

# Logout
if (!empty($_GET['logout'])) {
	$core->session->destroy();
	if (isset($_COOKIE['dc_admin'])) {
		unset($_COOKIE['dc_admin']);
		setcookie('dc_admin',null,0,'/');
	}
	http::redirect('auth.php');
	exit;
}

# Latest news for dashboard
$latest_news = '<h3>'.__('Latest news').'</h3>';
try
{
	$feed_reader = new feedReader;
	$feed_reader->setCacheDir(DC_TPL_CACHE);
	$feed_reader->setTimeout(2);
	$feed_reader->setUserAgent('Dotclear - http://www.dotclear.net/');
	$feed = $feed_reader->parse(DC_NEWS_FEED);
	if ($feed)
	{
		$latest_news .= '<ul>';
		$i = 1;
		foreach ($feed->items as $item) {
			$latest_news .= '<li><a href="'.$item->link.'">'.$item->title.'</a></li>';
			$i++;
			if ($i > 10) { break; }
		}
		$latest_news .= '</ul>';
	}
	else
	{
		throw new Exception('No news');
	}
}
catch (Exception $e)
{
	$latest_news .= '<p>'.__('No news').'</p>';
}
$__dashboard_items[1][] = $latest_news;

dcPage::open(__('Dashboard'));

echo '<h2>'.html::escapeHTML($core->blog->name).' &gt; '.__('Dashboard').'</h2>';

if ($core->auth->getInfo('user_default_blog') != $core->blog->id
&& count($core->blogs) > 1) {
	echo
	'<p id="default-blog"><a href="index.php?default_blog=1">'.
	__('Make this blog my default blog').'</a></p>';
}

if ($core->blog->status == 0) {
	echo '<p class="static-msg">'.__('This blog is offline').'</p>';
} elseif ($core->blog->status == -1) {
	echo '<p class="static-msg">'.__('This blog is removed').'</p>';
}

$rs = $core->blog->getPosts(array(),true);
$post_count = $rs->f(0);
$str_entries = ($post_count > 1) ? __('%d entries') : __('%d entry');

$rs = $core->blog->getComments(array(),true);
$comment_count = $rs->f(0);
$str_comments = ($comment_count > 1) ? __('%d comments') : __('%d comment');

unset($rs);

array_unshift($__dashboard_items[0],
	'<p><img src="images/menu/edit-b.png" alt="" />  <strong><a href="post.php">'.
	__('New entry').'</a></strong></p>'.
	'<p><img src="images/menu/entries-b.png" alt="" /> <a href="posts.php">'.
	sprintf($str_entries,$post_count).'</a></p>'.
	'<p><img src="images/menu/comments-b.png" alt="" /> <a href="comments.php">'.
	sprintf($str_comments,$comment_count).'</a></p>'
);

if ($core->auth->check('admin',$core->blog->id))
{
	array_unshift($__dashboard_items[1],
		'<p><img src="images/menu/blog-pref-b.png" alt="" /> '.
		'<a href="blog_pref.php">'.__('Blog settings').'</a></p>'.
		'<p><img src="images/menu/blog-theme-b.png" alt="" /> '.
		'<a href="blog_theme.php">'.__('Theme settings').'</a></p>'
	);
}

array_unshift($__dashboard_items[1],
	'<p><img src="images/menu/user-pref-b.png" alt="" />  <a href="preferences.php">'.
	__('User preferences').'</a></p>'
);

if (!DC_ADMIN_URL) {
	echo
	'<p class="static-msg">'.
	__('DC_ADMIN_URL is not defined, you should edit your configuration file.').
	'</p>';
}

echo
'<div id="dashboard" class="two-cols">'.
'<div class="col">';

foreach ($__dashboard_items[0] as $v) {
	echo $v;
}

echo
'</div>'.
'<div class="col">';

foreach ($__dashboard_items[1] as $v) {
	echo $v;
}

echo '</div></div>';

?>
<?php dcPage::close(); ?>