<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('usage,contentadmin');

$params = array();
$redir = 'comments.php';

if (!empty($_POST['action']) && !empty($_POST['comments']))
{
	$comments = $_POST['comments'];
	$action = $_POST['action'];
	
	$redir =
	'comments.php?type='.$_POST['type'].
	'&author='.$_POST['author'].
	'&sortby='.$_POST['sortby'].
	'&order='.$_POST['order'].
	'&page='.$_POST['page'].
	'&nb='.(integer) $_POST['nb'];
	
	foreach ($comments as $k => $v) {
		$comments[$k] = (integer) $v;
	}
	
	$params['sql'] = 'AND C.comment_id IN('.implode(',',$comments).') ';
	$params['no_content'] = true;
	
	$co = $core->blog->getComments($params);
	
	if (preg_match('/^(publish|unpublish|pending|junk)$/',$action))
	{
		switch ($action) {
			case 'unpublish' : $status = 0; break;
			case 'pending' : $status = -1; break;
			case 'junk' : $status = -2; break;
			default : $status = 1; break;
		}
		
		while ($co->fetch())
		{
			try {
				$core->blog->updCommentStatus($co->comment_id,$status);
			} catch (Exception $e) {
				$core->error->add($e->getMessage());
			}
		}
		
		if (!$core->error->flag()) {
			http::redirect($redir);
		}
	}
	elseif ($action == 'delete')
	{
		while ($co->fetch())
		{
			try {
				$core->blog->delComment($co->comment_id);
			} catch (Exception $e) {
				$core->error->add($e->getMessage());
			}
		}
		
		if (!$core->error->flag()) {
			http::redirect($redir);
		}
	}
}

/* DISPLAY
-------------------------------------------------------- */
dcPage::open(__('Comments'));

echo '<p><a href="'.str_replace('&','&amp;',$redir).'">'.__('back').'</a></p>';

dcPage::close();
?>