<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/class.widgets.php';

# Available widgets
global $__widgets;
$__widgets = new dcWidgets;

$__widgets->create('search',__('Search engine'),array('defaultWidgets','search'));
$__widgets->search->setting('title',__('Title:'),__('Search'));

$__widgets->create('navigation',__('Navigation links'),array('defaultWidgets','navigation'));

$__widgets->create('bestof',__('Selected entries'),array('defaultWidgets','bestof'));
$__widgets->bestof->setting('title',__('Title:'),__('Best of me'));
$__widgets->bestof->setting('homeonly',__('Home page only'),1,'check');

$__widgets->create('langs',__('Blog languages'),array('defaultWidgets','langs'));
$__widgets->langs->setting('title',__('Title:'),__('Languages'));
$__widgets->langs->setting('homeonly',__('Home page only'),1,'check');

$__widgets->create('categories',__('Categories list'),array('defaultWidgets','categories'));
$__widgets->categories->setting('title',__('Title:'),__('Categories'));
$__widgets->categories->setting('postcount',__('With entries counts'),0,'check');

$__widgets->create('subscribe',__('Subscribe links'),array('defaultWidgets','subscribe'));
$__widgets->subscribe->setting('title',__('Title:'),__('Subscribe'));
$__widgets->subscribe->setting('type',__('Feeds type:'),'rss2','combo',array('RSS' => 'rss2','Atom' => 'atom'));

$__widgets->create('feed',__('Feed reader'),array('defaultWidgets','feed'));
$__widgets->feed->setting('title',__('Title:'),__('Somewhere else'));
$__widgets->feed->setting('url',__('Feed URL:'),'');
$__widgets->feed->setting('limit',__('Entries limit:'),10);
$__widgets->feed->setting('homeonly',__('Home page only'),1,'check');

$__widgets->create('text',__('Text'),array('defaultWidgets','text'));
$__widgets->text->setting('title',__('Title:'),'');
$__widgets->text->setting('text',__('Text:'),'','textarea');
$__widgets->text->setting('homeonly',__('Home page only'),0,'check');

$__widgets->create('lastposts',__('Last entries'),array('defaultWidgets','lastposts'));
$__widgets->lastposts->setting('title',__('Title:'),__('Last entries'));
$__widgets->lastposts->setting('limit',__('Entries limit:'),10);
$__widgets->lastposts->setting('homeonly',__('Home page only'),1,'check');

$__widgets->create('lastcomments',__('Last comments'),array('defaultWidgets','lastcomments'));
$__widgets->lastcomments->setting('title',__('Title:'),__('Last comments'));
$__widgets->lastcomments->setting('limit',__('Comments limit:'),10);
$__widgets->lastcomments->setting('homeonly',__('Home page only'),1,'check');

# --BEHAVIOR-- initWidgets
$core->callBehavior('initWidgets',$__widgets);

# Default widgets
global $__default_widgets;
$__default_widgets = array('nav'=> new dcWidgets(), 'extra'=> new dcWidgets());

$__default_widgets['nav']->append($__widgets->search);
$__default_widgets['nav']->append($__widgets->navigation);
$__default_widgets['nav']->append($__widgets->bestof);
$__default_widgets['nav']->append($__widgets->categories);
$__default_widgets['extra']->append($__widgets->subscribe);

# --BEHAVIOR-- initWidgets
$core->callBehavior('initDefaultWidgets',$__widgets,$__default_widgets);
?>