<?php
# ***** BEGIN LICENSE BLOCK *****
# This is spamplemousse, a plugin for DotClear. 
# Copyright (c) 2005 Benoit CLERC, Alain Vagner and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$_menu['Plugins']->addItem('Akismet','plugin.php?p=akismet','index.php?pf=akismet/icon.png',
		preg_match('/plugin.php\?p=akismet(&.*)?$/',$_SERVER['REQUEST_URI']),
		$core->auth->check('admin',$core->blog->id));

$core->addBehavior('coreAfterCommentUpdate',array('akismetBehaviors','coreAfterCommentUpdate'));

class akismetBehaviors
{
	public static function coreAfterCommentUpdate(&$blog,&$cur,&$rs)
	{
		if (!$blog->settings->ak_key || !$blog->settings->ak_active) {
			return;
		}
		
		$status = null;
		# From ham to spam
		if ($rs->comment_status != -2 && $cur->comment_status == -2) {
			$status = 'spam';
		}
		
		# From spam to ham
		if ($rs->comment_status == -2	 && $cur->comment_status == 1) {
			$status = 'ham';
		}
		
		if ($status)
		{
			$ak = new akismet($blog->url,$blog->settings->ak_key);
			$func = 'submit_'.$status;
			try
			{
				$ak->$func(
					$rs->getPostURL(),
					$rs->comment_trackback ? 'trackback' : 'comment',
					$rs->comment_author,
					$rs->comment_email,
					$rs->comment_site,
					$rs->comment_content
				);
			}
			catch (Exception $e) { /* If http or akismet is dead, we don't need to know it */ }
		}
	}
}
?>