<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

# Blogroll template functions

require dirname(__FILE__).'/_widgets.php';

$core->tpl->addValue('Blogroll',array('tplBlogroll','blogroll'));
$core->tpl->addValue('BlogrollXbelLink',array('tplBlogroll','blogrollXbelLink'));

$core->url->register('xbel','xbel','^xbel(?:/?)$',array('urlBlogroll','xbel'));

class tplBlogroll
{
	public static function blogroll($attr)
	{
		$category='<h3>%s</h3>';
		$block='<ul>%s</ul>';
		$item='<li>%s</li>';
		
		if (isset($attr['category'])) {
			$category = addslashes($attr['category']);
		}
		
		if (isset($attr['block'])) {
			$block = addslashes($attr['block']);
		}
		
		if (isset($attr['item'])) {
			$item = addslashes($attr['item']);
		}
		
		return
		'<?php '.
		"echo tplBlogroll::getList('".$category."','".$block."','".$item."'); ".
		'?>';
	}
	
	public static function blogrollXbelLink($attr)
	{
		$f = $GLOBALS['core']->tpl->getFilters($attr);
		return '<?php echo '.sprintf($f,'$core->blog->url.$core->url->getBase("xbel")').'; ?>';
	}
	
	public static function getList($category='<h3>%s</h3>',$block='<ul>%s</ul>',$item='<li>%s</li>')
	{
		require_once dirname(__FILE__).'/class.dc.blogroll.php';
		$blogroll = new dcBlogroll($GLOBALS['core']->blog);
		
		try {
			$links = $blogroll->getLinks();
		} catch (Exception $e) {
			return false;
		}
		
		$res = '';
		
		foreach ($blogroll->getLinksHierarchy($links) as $k => $v)
		{
			if ($k != '') {
				$res .= sprintf($category,html::escapeHTML($k))."\n";
			}
			
			$res .= self::getLinksList($v,$block,$item);
		}
		
		return $res;
	}
	
	private static function getLinksList($links,$block='<ul>%s</ul>',$item='<li>%s</li>')
	{
		$list = '';
		
		foreach ($links as $v)
		{
			$title = $v['link_title'];
			$href  = $v['link_href'];
			$desc = $v['link_desc'];
			$lang  = $v['link_lang'];
			$xfn = $v['link_xfn'];
			
			$link =
			'<a href="'.html::escapeHTML($href).'"'.
			((!$lang) ? '' : ' hreflang="'.html::escapeHTML($lang).'"').
			((!$desc) ? '' : ' title="'.html::escapeHTML($desc).'"').
			((!$xfn) ? '' : ' rel="'.html::escapeHTML($xfn).'"').
			'>'.
			html::escapeHTML($title).
			'</a>';
				
			$list .= sprintf($item,$link)."\n";
		}
		
		return sprintf($block,$list)."\n";
	}
	
	# Widget function
	public static function linksWidget(&$w)
	{
		global $core;
		
		if ($w->homeonly && $core->url->type != 'default') {
			return;
		}
		
		return
		'<div id="links">'.
		($w->title ? '<h2>'.html::escapeHTML($w->title).'</h2>' : '').
		self::getList('<h3>%s</h3>','<ul>%s</ul>','<li>%s</li>').
		'</div>';
	}
}

class urlBlogroll extends dcUrlHandlers
{
	public static function xbel($args)
	{
		require dirname(__FILE__).'/class.dc.blogroll.php';
		$blogroll = new dcBlogroll($GLOBALS['core']->blog);
		
		try {
			$links = $blogroll->getLinks();
		} catch (Exception $e) {
			self::p404();
		}
		
		if ($args) {
			self::p404();
		}
		
		http::cache($GLOBALS['mod_files'],$GLOBALS['mod_ts']);
		
		header('Content-Type: text/xml; charset=UTF-8');
		
		echo
		'<?xml version="1.0" encoding="UTF-8"?>'."\n".
		'<!DOCTYPE xbel PUBLIC "+//IDN python.org//DTD XML Bookmark Exchange '.
		'Language 1.0//EN//XML"'."\n".
		'"http://www.python.org/topics/xml/dtds/xbel-1.0.dtd">'."\n".
		'<xbel version="1.0">'."\n".
		'<title>'.html::escapeHTML($GLOBALS['core']->blog->name)." blogroll</title>\n";
		
		$i = 1;
		foreach ($blogroll->getLinksHierarchy($links) as $cat_title => $links)
		{
			if ($cat_title != '') {
				echo
				'<folder>'."\n".
				"<title>".html::escapeHTML($cat_title)."</title>\n";
			}
			
			foreach ($links as $k => $v)
			{
				$lang = $v['link_lang'] ? ' xml:lang="'.$v['link_lang'].'"' : '';
				
				echo
				'<bookmark href="'.$v['link_href'].'"'.$lang.'>'."\n".
				'<title>'.html::escapeHTML($v['link_title'])."</title>\n";
				
				if ($v['link_desc']) {
					echo '<desc>'.html::escapeHTML($v['link_desc'])."</desc>\n";
				}
				
				if ($v['link_xfn']) {
					echo
					"<info>\n".
					'<metadata owner="http://gmpg.org/xfn/">'.$v['link_xfn']."</metadata>\n".
					"</info>\n";
				}
				
				echo
				"</bookmark>\n";
			}
			
			if ($cat_title != '') {
				echo "</folder>\n";
			}
			
			$i++;
		}
		
		echo
		'</xbel>';
		
		exit;
	}
}
?>