<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::checkSuper();

$blog_id = '';

if (!empty($_POST['blog_id']))
{
	try {
		$rs = $core->getBlog($_POST['blog_id']);
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
	
	if ($rs->isEmpty()) {
		$core->error->add(__('No such blog ID'));
	} else {
		$blog_id = $rs->blog_id;
	}
}

# Delete the blog
if (!$core->error->flag() && $blog_id && !empty($_POST['del']))
{
	if (!$core->auth->checkPassword(crypt::hmac(DC_MASTER_KEY,$_POST['pwd']))) {
		$core->error->add(__('Password verification failed'));
	} else {
		try {
			$core->delBlog($blog_id);
			http::redirect('blogs.php?del=1');
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
	}
}

dcPage::open('Delete a blog');

if (!$core->error->flag())
{
	echo
	'<h2>'.__('Delete a blog').'</h2>'.
	'<p class="message">'.__('Warning').'</p>'.
	'<p>'.sprintf(__('You are about to delete the blog %s. Every entry, comment and category will be deleted.'),
	'<strong>'.$blog_id.'</strong>').'</p>'.
	'<p>'.__('Please give your password to confirm the blog deletion.').'</p>';
	
	echo
	'<form action="blog_del.php" method="post">'.
	'<p><label>'.__('Your password:').' '.
	form::password('pwd',20,255).'</label></p>'.
	'<p><input type="submit" name="del" value="'.__('Delete this blog').'" />'.
	form::hidden('blog_id',$blog_id).'</p>'.
	'</form>';
}

dcPage::close();
?>