var dragdrop = ToolMan.dragdrop();
chainHandler(window,'onload',function() {
	var widgets = document.getElementById('widgets');
	var w_nav = document.getElementById('dndnav');
	var w_ext = document.getElementById('dndextra');
	
	w_nav.className = 'hideControls';
	w_ext.className = 'hideControls';
	
	removeElements(document.getElementById('listWidgets'),'input');
	removeElements(widgets,'p');
	removeElements(w_nav,'p');
	removeElements(w_ext,'p');
	hideElements(w_nav,'input');
	hideElements(w_ext,'input');
	
	configControls(w_nav);
	configControls(w_ext);
	
	dragdrop.makeListContainer(widgets,'div',setHandle);
	if (!document.all) { widgets.factory = true; }
	dragdrop.makeListContainer(w_nav,'div',setHandle);
	w_nav.onDragEnd = navDragEnd;
	dragdrop.makeListContainer(w_ext,'div',setHandle);
	w_ext.onDragEnd = extraDragEnd;
	
	// Helper to remove some elements
	function removeElements(p,name) {
		name = name || 'div';
		var E = getElementsByNameAndClass(name,'js-remove',p);
		for (var e in E) {
			E[e].parentNode.removeChild(E[e]);
		}
	}
	
	// Helper to hide elements (but keep them)
	function hideElements(p,name) {
		name = name || 'div';
		var E = getElementsByNameAndClass(name,'js-hide',p);
		for (var e in E) {
			E[e].style.display = 'none';
		}
	}	
	
	function removeEmptyMsg(p) {
		var E = getElementsByNameAndClass('p','empty-widgets',p);
		if (E.length > 0) {
			E[0].parentNode.removeChild(E[0]);
		}
	}
	
	// Events on dragEnd
	function navDragEnd() {
		formControls(this.parentNode,'nav');
		configControls(this.parentNode);
		removeEmptyMsg(this.parentNode);
	}
	function extraDragEnd() {
		formControls(this.parentNode,'extra');
		configControls(this.parentNode);
		removeEmptyMsg(this.parentNode);
	}
	
	// dragEnd helper
	function formControls(e,pr) {
		var items = new Array();
		for (var i=0; i<e.childNodes.length; i++) {
			if (e.childNodes[i].nodeType == 1 && e.childNodes[i].nodeName.toLowerCase() == 'div') {
				items.push(e.childNodes[i]);
			}
		}
		
		var fields, itype;
		var r = new RegExp('^w\[[a-z]+]\[[0-9]+][[](.+?)]$','');
		for (i in items) {
			// Change field names
			fields = getFormControls(items[i]);
			var j;
			for (j in fields) {
				if (r.test(fields[j].name)) {
					itype = fields[j].name.replace(r,'$1');
					fields[j].name = 'w['+pr+']['+i+']['+itype+']';
					
					if (itype == 'order') {
						fields[j].value = i;
					}
				}
			}
		}
	}
	
	function getFormControls(e) {
		var input = e.getElementsByTagName('input');
		var textarea = e.getElementsByTagName('textarea');
		var select = e.getElementsByTagName('select');
		var items = new Array();
		var i;
		for (i in input) { items.push(input[i]); }
		for (i in select) { items.push(select[i]); }
		for (i in textarea) { items.push(textarea[i]); }
		
		return items;
	}
	
	function configControls(e) {
		var items = new Array();
		for (var i=0; i<e.childNodes.length; i++) {
			if (e.childNodes[i].nodeType == 1 && e.childNodes[i].nodeName.toLowerCase() == 'div') {
				items.push(e.childNodes[i]);
			}
		}
		
		var title, img_ctrl, img, space;
		for (i in items) {
			// Append config control
			title = items[i].getElementsByTagName('h4').item(0);
			img_ctrl = title.firstChild;
			
			// There already an image
			if (img_ctrl.nodeName.toLowerCase() == 'img') {
				continue;
			}
			
			// Nothing to configure
			if (title.nextSibling.childNodes.length == 0) {
				continue;
			}
			
			img = document.createElement('img');
			img.src = 'images/plus.png';
			img.alt = '[+]';
			img.control = title.nextSibling;
			img.onclick = function() { widgetConfig.call(this); };
			space = document.createTextNode(' ');
			title.insertBefore(img,img_ctrl);
			title.insertBefore(space,img_ctrl);
		}
	}
	
	function widgetConfig() {
		if (this.control.style.display == 'block') {
			this.control.style.display = 'none';
			this.src = 'images/plus.png';
			this.alt = '[+]';
		} else {
			this.control.style.display = 'block';
			this.src = 'images/minus.png';
			this.alt = '[-]';
		}
	}
	
	function setHandle(item) {
		var handle = item.getElementsByTagName('h4').item(0);
		handle.className = 'handler';
		item.toolManDragGroup.setHandle(handle);
	}
});