<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of Clearbricks.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# Clearbricks is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# Clearbricks is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Clearbricks; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class url
{
	
	public static function parse()
	{
		if (!isset($_SERVER['QUERY_STRING'])) {
			return array();
		}
		
		$res = array();
		foreach (explode('&',$_SERVER['QUERY_STRING']) as $v) {
			$p = explode('=',$v);
			$N = rawurldecode($p[0]);
			$V = isset($p[1]) ? rawurldecode($p[1]) : null;
			$res[$N] = $V;
		}
		
		return $res;
	}
	
	public static function argument($name,$value)
	{
		$args = self::parse();
		$args[$name] = $value;
		
		return self::buildQueryString($args);
	}
	
	public static function buildQueryString($args)
	{
		$res = array();
		foreach ($args as $k => $v) {
			$res[] = $k.($v ? '='.$v : '');
		}
		
		return implode('&',$res);
	}
	
	public static function escape($url)
	{
		return html::escape($url);
	}
}
?>