<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of Clearbricks.
# Copyright (c) 2004 Florent Cotton, Olivier Meunier and contributors.
# All rights reserved.
#
# Clearbricks is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# Clearbricks is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Clearbricks; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

# Autoload stuff
$__autoload = array(
	# Classes
	'feedParser'		=> dirname(__FILE__).'/class.feed.parser.php',
	'feedReader'		=> dirname(__FILE__).'/class.feed.reader.php',
	'filemanager'		=> dirname(__FILE__).'/class.filemanager.php',
	'fileItem'		=> dirname(__FILE__).'/class.filemanager.php',
	'htmlFilter'		=> dirname(__FILE__).'/class.html.filter.php',
	'imageMeta'		=> dirname(__FILE__).'/class.image.meta.php',
	'imageTools'		=> dirname(__FILE__).'/class.image.tools.php',
	'mail'			=> dirname(__FILE__).'/class.mail.php',
	'socketMail'		=> dirname(__FILE__).'/class.mail.php',
	'pager'			=> dirname(__FILE__).'/class.pager.php',
	'restServer'		=> dirname(__FILE__).'/class.rest.php',
	'sessionDB'		=> dirname(__FILE__).'/class.session.db.php',
	'xmlTag'			=> dirname(__FILE__).'/class.rest.php',
	'template'		=> dirname(__FILE__).'/class.template.php',
	'urlHandler'		=> dirname(__FILE__).'/class.url.handler.php',
	'wiki2xhtml'		=> dirname(__FILE__).'/class.wiki2xhtml.php',
	'xmlsql'			=> dirname(__FILE__).'/class.xmlsql.php',
	
	# Libraries
	'crypt'			=> dirname(__FILE__).'/lib.crypt.php',
	'dt'				=> dirname(__FILE__).'/lib.date.php',
	'files'			=> dirname(__FILE__).'/lib.files.php',
	'path'			=> dirname(__FILE__).'/lib.files.php',
	'form'			=> dirname(__FILE__).'/lib.form.php',
	'formSelectOption'	=> dirname(__FILE__).'/lib.form.php',
	'html'			=> dirname(__FILE__).'/lib.html.php',
	'http'			=> dirname(__FILE__).'/lib.http.php',
	'text'			=> dirname(__FILE__).'/lib.text.php',
	
	# Database layer
	'dbLayer'			=> dirname(__FILE__).'/dblayer/dblayer.php',
	
	# Third party libs
	'HttpClient'				=> dirname(__FILE__).'/ext/incutio.http_client.php',
	'IXR_Value'				=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_Message'				=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_Server'				=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_Request'				=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_Client'				=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_Error'				=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_Date'				=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_Base64'				=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_IntrospectionServer'	=> dirname(__FILE__).'/ext/incutio.ixr_library.php',
	'IXR_ClientMulticall'		=> dirname(__FILE__).'/ext/incutio.ixr_library.php'
);

function __autoload($name)
{
	global $__autoload;
	
	if (isset($__autoload[$name])) {
		require_once $__autoload[$name];
	}
}

# We only need l10n __() function
require_once dirname(__FILE__).'/lib.l10n.php';
?>