<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('usage,contentadmin');

try
{
	$hfile = '%s/help/%s/%s.html';
	
	$p = !empty($_GET['p']) ? $_GET['p'] : 'index';
	$p = preg_replace('#[./]#','',$p);
	
	$lang = $core->auth->getInfo('user_lang');
	$root = dirname(__FILE__);
	
	$help_file = sprintf($hfile,$root,$lang,$p);
	
	if (!file_exists($help_file)) {
		$help_file = sprintf($hfile,$root,'en',$p);
	}
	
	if (!file_exists($help_file)) {
		throw new Exception('Help file does not exist.');
	}
	
	$fc = file_get_contents($help_file);
	
	if (preg_match('|<title[^>]*?>(.*?)</title>.*<body[^>]*?>(.*?)</body>|ms',
		$fc,$matches))
	{
			$title = $matches[1];
			$page_content = $matches[2];
	}
	else
	{
		throw new Exception('No content for this file.');
	}
	
	# Set page title
	if ($p != 'index') {
		$page_title = '<a href="help.php?p=index">'.__('Online help').'</a> &gt; '.$title;
	} else {
		$page_title = $title;
	}
	
	# Change every link in content
	$page_content = preg_replace('|href="(.*?).html(#.*?)?"|ms','href="help.php?p=$1$2"',$page_content);
}
catch (Exception $e)
{
	$title = __('error');
	$core->error->add($e->getMessage());
}

dcPage::openPopup($title);

if (!empty($page_content)) {
	echo '<h2>'.$page_title.'</h2>';
	echo '<div class="help-content">'.$page_content.'</div>';
}

echo '<p><a href="#" onclick="window.close();">'.__('Close this window').'</a></p>';

dcPage::closePopup();
?>