<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../inc/admin/prepend.php';

dcPage::check('usage,contentadmin');

$comment_id = null;
$comment_dt = '';
$comment_author = '';
$comment_email = '';
$comment_site = '';
$comment_content = '';
$comment_ip = '';
$comment_status = '';
$comment_trackback = 0;
$comment_spam_status = '';

# Status combo
foreach ($core->blog->getAllCommentStatus() as $k => $v) {
	$status_combo[$v] = (string) $k;
}

# Adding comment
if (!empty($_POST['add']) && !empty($_POST['post_id']))
{
	$cur = $core->con->openCursor($core->prefix.'comment');
	
	$cur->comment_author = $_POST['comment_author'];
	$cur->comment_email = html::clean($_POST['comment_email']);
	$cur->comment_site = html::clean($_POST['comment_site']);
	$cur->comment_content = $core->HTMLfilter($_POST['comment_content']);
	$cur->post_id = (integer) $_POST['post_id'];
	
	try {
		$core->blog->addComment($cur);
		http::redirect('post.php?id='.$_POST['post_id']);
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}

if (!empty($_REQUEST['id']))
{
	$params['comment_id'] = $_REQUEST['id'];
	
	try {
		$rs = $core->blog->getComments($params);
		if (!$rs->isEmpty()) {
			$comment_id = $rs->comment_id;
			$post_id = $rs->post_id;
			$comment_dt = $rs->comment_dt;
			$comment_author = $rs->comment_author;
			$comment_email = $rs->comment_email;
			$comment_site = $rs->comment_site;
			$comment_content = $rs->comment_content;
			$comment_ip = $rs->comment_ip;
			$comment_status = $rs->comment_status;
			$comment_trackback = (boolean) $rs->comment_trackback;
			$comment_spam_status = $rs->comment_spam_status;
		}
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}

if (!$comment_id && !$core->error->flag()) {
	$core->error->add(__('No comment'));
}

if (!$core->error->flag() && isset($rs))
{
	$can_edit = $can_delete = $can_publish = $core->auth->check('contentadmin',$core->blog->id);
	
	if (!$core->auth->check('contentadmin',$core->blog->id) && $core->auth->userID() == $rs->user_id) {
		$can_edit = true;
		if ($core->auth->check('delete',$core->blog->id)) {
			$can_delete = true;
		}
		if ($core->auth->check('publish',$core->blog->id)) {
			$can_publish = true;
		}
	}
	
	# update comment
	if (!empty($_POST['update']))
	{
		$cur = $core->con->openCursor($core->prefix.'comment');
		
		$cur->comment_author = $_POST['comment_author'];
		$cur->comment_email = html::clean($_POST['comment_email']);
		$cur->comment_site = html::clean($_POST['comment_site']);
		$cur->comment_content = $core->HTMLfilter($_POST['comment_content']);
		
		if (isset($_POST['comment_status'])) {
			$cur->comment_status = (integer) $_POST['comment_status'];
		}
		
		try {
			$core->blog->updComment($comment_id,$cur);
			http::redirect('comment.php?id='.$comment_id.'&upd=1');
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
	}
	
	if (!empty($_POST['delete'])) {
		$_POST['action'] = 'delete';
	}
	
	if (!empty($_POST['action']) && $can_edit)
	{
		switch ($_POST['action']) {
			case 'delete':
				try {
					$core->blog->delComment($rs->comment_id);
					http::redirect('post.php?id='.$rs->post_id);
				} catch (Exception $e) {
					$core->error->add($e->getMessage());
				}
				break;
			case 'junk':
				try {
					$cur = $core->con->openCursor($core->prefix.'comment');
					$cur->comment_status = -2;
					$core->blog->updComment($rs->comment_id,$cur);
					http::redirect('post.php?co=1&id='.$rs->post_id.'#c'.$rs->comment_id);
				} catch (Exception $e) {
					$core->error->add($e->getMessage());
				}
				break;
			case 'status':
				try {
					$cur = $core->con->openCursor($core->prefix.'comment');
					$cur->comment_status = $rs->comment_status == 1 ? -1 : 1;
					$core->blog->updComment($rs->comment_id,$cur);
					http::redirect('post.php?co=1&id='.$rs->post_id.'#c'.$rs->comment_id);
				} catch (Exception $e) {
					$core->error->add($e->getMessage());
				}
				break;
		}
	}
	
	if (!$can_edit) {
		$core->error->add(__("You can't edit this comment."));
	}
}

/* DISPLAY
-------------------------------------------------------- */
dcPage::open(__('Edit comment'),
	dcPage::jsConfirmClose('comment-form').
	dcPage::jsToolBar().
	'<script type="text/javascript" src="js/_comment.js"></script>'
);

if ($comment_id)
{
	echo '<h2>'.__('Edit comment').'</h2>';
	
	echo '<p><a href="post.php?co=1&amp;id='.$post_id.'#c'.$comment_id.'">'.
		__('Back to entry').'</a></p>';
	
	echo
	'<form action="comment.php" method="post" id="comment-form">'.
	'<p><label>'.__('IP address:').'</label> '.
	$comment_ip.'</p>'.
	
	'<p><label>'.__('Date:').'</label> '.
	dt::dt2str(__('%Y-%m-%d %H:%M'),$comment_dt).'</p>'.
	
	'<p><label class="required" title="'.__('Required field').'">'.__('Author:').
	dcPage::help('comments','c_author').
	form::field('comment_author',30,255,html::escapeHTML($comment_author)).
	'</label></p>'.
	
	'<p><label>'.__('Email:').dcPage::help('comments','c_email').
	form::field('comment_email',30,255,html::escapeHTML($comment_email)).
	'</label></p>'.
	
	'<p><label>'.__('Web site:').dcPage::help('comments','c_site').
	form::field('comment_site',30,255,html::escapeHTML($comment_site)).
	'</label></p>'.
	
	'<p><label>'.__('Status:').dcPage::help('comments','c_status').
	form::combo('comment_status',$status_combo,$comment_status,'','',!$can_publish).
	'</label></p>'.
	
	(($comment_status == -2) ? '<p><strong>'.$comment_spam_status.'</strong></p>' : '').
	
	'<p class="area"><label for="comment_content">'.__('Comment:').
	dcPage::help('comments','c_comment').'</label> '.
	form::textarea('comment_content',50,10,html::escapeHTML($comment_content)).
	'</p>'.
	
	'<p>'.form::hidden('id',$comment_id).
	'<input type="submit" name="update" value="'.__('save').'" /> ';
	
	if ($can_delete) {
		echo '<input type="submit" name="delete" value="'.__('delete').'" '.
		'onclick="return window.confirm('.
		'\''.html::escapeJS(__('Are you sure you want to delete this comment?')).'\');" />';
	}
	echo
	'</p>'.
	'</form>';
}

dcPage::close();
?>