<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class rsExtPost
{
	public static function isEditable(&$rs)
	{
		# If user is admin or contentadmin, true
		if ($rs->core->auth->check('contentadmin',$rs->core->blog->id)) {
			return true;
		}
		
		# No user id in result ? false
		if (!$rs->exists('user_id')) {
			return false;
		}
		
		# If user is usage and owner of the entrie
		if ($rs->core->auth->check('usage',$rs->core->blog->id)
		&& $rs->user_id == $rs->core->auth->userID()) {
			return true;
		}
		
		return false;
	}
	
	public static function firstPostOfDay(&$rs)
	{
		if ($rs->isStart()) {
			return true;
		}
		
		$cdate = date('Ymd',strtotime($rs->post_dt));
		$rs->movePrev();
		$ndate = date('Ymd',strtotime($rs->post_dt));
		$rs->moveNext();
		return $ndate != $cdate;
	}
	
	public static function lastPostOfDay(&$rs)
	{
		if ($rs->isEnd()) {
			return true;
		}
		
		$cdate = date('Ymd',strtotime($rs->post_dt));
		$rs->moveNext();
		$ndate = date('Ymd',strtotime($rs->post_dt));
		$rs->movePrev();
		return $ndate != $cdate;
	}
	
	public static function commentsActive(&$rs)
	{
		return
		$rs->core->blog->settings->allow_comments
		&& $rs->post_open_comment
		&& ($rs->core->blog->settings->comments_ttl == 0 ||
		time()-($rs->core->blog->settings->comments_ttl*86400) < $rs->getTS());
	}
	
	public static function trackbacksActive(&$rs)
	{
		return
		$rs->core->blog->settings->allow_trackbacks
		&& $rs->post_open_tb
		&& ($rs->core->blog->settings->comments_ttl == 0 ||
		time()-($rs->core->blog->settings->comments_ttl*86400) < $rs->getTS());
	}
	
	public static function hasComments(&$rs)
	{
		return $rs->nb_comment > 0;
	}
	
	public static function hasTrackbacks(&$rs)
	{
		return $rs->nb_trackback > 0;
	}
	
	public static function getURL(&$rs)
	{
		return $rs->core->blog->url.$rs->core->url->getBase('post').'/'.
		html::sanitizeURL($rs->post_url);
	}
	
	public static function getCategoryURL(&$rs)
	{
		return $rs->core->blog->url.$rs->core->url->getBase('category').'/'.
		html::sanitizeURL($rs->cat_url);
	}
	
	public static function isExtended(&$rs)
	{
		return $rs->post_excerpt_xhtml != '';
	}
	
	public static function getTS(&$rs)
	{
		return strtotime($rs->post_dt);
	}
	
	public static function getISO8601Date(&$rs)
	{
		return dt::iso8601($rs->getTS(),$rs->post_tz);
	}
	
	public static function getRFC822Date(&$rs)
	{
		return dt::rfc822($rs->getTS(),$rs->post_tz);
	}
	
	public static function getDate(&$rs,$format)
	{
		if ($format) {
			return dt::dt2str($format,$rs->post_dt);
		} else {
			return dt::dt2str($rs->core->blog->settings->date_format,$rs->post_dt);
		}
	}
	
	public static function getTime(&$rs,$format)
	{
		if ($format) {
			return dt::dt2str($format,$rs->post_dt);
		} else {
			return dt::dt2str($rs->core->blog->settings->time_format,$rs->post_dt);
		}
	}
	
	public static function getAuthorCN(&$rs)
	{
		return dcUtils::getUserCN($rs->user_id, $rs->user_name,
		$rs->user_firstname, $rs->user_displayname);
	}
	
	public static function getAuthorLink(&$rs)
	{
		$res = '%1$s';
		$url = $rs->user_url;
		if ($url) {
			$res = '<a href="%2$s">%1$s</a>';
		}
		
		return sprintf($res,$rs->getAuthorCN(),$url);
	}
	
	public static function getAuthorEmail(&$rs,$encoded=true)
	{
		if ($encoded) {
			return strtr($rs->user_email,array('@'=>'%40','.'=>'%2e'));
		}
		return $rs->user_email;
	}
	
	public static function getFeedID(&$rs)
	{
		return 'urn:md5:'.md5($rs->core->blog->uid.$rs->post_id);
		
		$url = parse_url($rs->core->blog->url);
		$date_part = date('Y-m-d',strtotime($rs->post_creadt));
		
		return 'tag:'.$url['host'].','.$date_part.':'.$rs->post_id;
	}
	
	public static function getTrackbackData(&$rs)
	{
		return
		"<!--\n".
		'<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"'."\n".
		'  xmlns:dc="http://purl.org/dc/elements/1.1/"'."\n".
		'  xmlns:trackback="http://madskills.com/public/xml/rss/module/trackback/">'."\n".
		"<rdf:Description\n".
		'  rdf:about="'.$rs->getURL().'"'."\n".
		'  dc:identifier="'.$rs->getURL().'"'."\n".
		'  dc:title="'.htmlspecialchars($rs->post_title,ENT_COMPAT,'UTF-8').'"'."\n".
		'  trackback:ping="'.$rs->getTrackbackLink().'" />'."\n".
		"</rdf:RDF>\n".
		"-->\n";
	}
	
	public static function getTrackbackLink(&$rs)
	{
		return $rs->core->blog->url.'trackback/'.$rs->post_id;
	}
	
	public static function getContent(&$rs,$absolute_urls=false)
	{
		if ($absolute_urls) {
			return html::absoluteURLs($rs->post_content_xhtml,$rs->getURL());
		} else {
			return $rs->post_content_xhtml;
		}
	}
	
	public static function getExcerpt(&$rs,$absolute_urls=false)
	{
		if ($absolute_urls) {
			return html::absoluteURLs($rs->post_excerpt_xhtml,$rs->getURL());
		} else {
			return $rs->post_excerpt_xhtml;
		}
	}
}

class rsExtComment
{
	public static function getDate(&$rs,$format)
	{
		if ($format) {
			return dt::dt2str($format,$rs->comment_dt);
		} else {
			return dt::dt2str($rs->core->blog->settings->date_format,$rs->comment_dt);
		}
	}
	
	public static function getTime(&$rs,$format)
	{
		if ($format) {
			return dt::dt2str($format,$rs->comment_dt);
		} else {
			return dt::dt2str($rs->core->blog->settings->time_format,$rs->comment_dt);
		}
	}
	
	public static function getTS(&$rs)
	{
		return strtotime($rs->comment_dt);
	}
	
	public static function getISO8601Date(&$rs)
	{
		return dt::iso8601($rs->getTS(),$rs->comment_tz);
	}
	
	public static function getRFC822Date(&$rs)
	{
		return dt::rfc822($rs->getTS(),$rs->comment_tz);
	}
	
	public static function getContent(&$rs,$absolute_urls=false)
	{
		$res = $rs->comment_content;
		
		if ($rs->core->blog->settings->comments_nofollow) {
			$res = preg_replace_callback('#<a(.*?href=".*?".*?)>#ms',array('self','noFollowURL'),$res);
		}
		
		if ($absolute_urls) {
			$res = html::absoluteURLs($res,$rs->getPostURL());
		}
		
		return $res;
	}
	
	private static function noFollowURL($m)
	{
		if (preg_match('/rel="nofollow"/',$m[1])) {
			return $m[0];
		}
		
		return '<a'.$m[1].' rel="nofollow">';
	}
	
	public static function getAuthorURL(&$rs)
	{
		if (trim($rs->comment_site)) {
			return trim($rs->comment_site);
		}
	}
	
	public static function getPostURL(&$rs)
	{
		return $rs->core->blog->url.$rs->core->url->getBase('post').'/'.
		html::sanitizeURL($rs->post_url);
	}
	
	public static function getAuthorLink(&$rs)
	{
		$res = '%1$s';
		$url = $rs->getAuthorURL();
		if ($url) {
			$res = '<a href="%2$s"%3$s>%1$s</a>';
		}
		
		$nofollow = '';
		if ($rs->core->blog->settings->comments_nofollow) {
			$nofollow = ' rel="nofollow"';
		}
		
		return sprintf($res,html::escapeHTML($rs->comment_author),$url,$nofollow);
	}
	
	public static function getEmail(&$rs,$encoded=true)
	{
		if ($encoded) {
			return strtr($rs->comment_email,array('@'=>'%40','.'=>'%2e'));
		}
		return $rs->comment_email;
	}
	
	public static function getTrackbackTitle(&$rs)
	{
		if ($rs->comment_trackback == 1 &&
		preg_match('|<p><strong>(.*?)</strong></p>|msU',$rs->comment_content,
		$match)) {
			return $match[1];
		}
	}
	
	public static function getTrackbackContent(&$rs)
	{
		if ($rs->comment_trackback == 1) {
			return preg_replace('|<p><strong>.*?</strong></p>|msU','',
			$rs->comment_content);
		}
	}
	
	public static function getFeedID(&$rs)
	{
		return 'urn:md5:'.md5($rs->core->blog->uid.$rs->comment_id);
		
		$url = parse_url($rs->core->blog->url);
		$date_part = date('Y-m-d',strtotime($rs->comment_dt));
		
		return 'tag:'.$url['host'].','.$date_part.':'.$rs->comment_id;
	}
	
	public static function isMe(&$rs)
	{
		return
		$rs->comment_email && $rs->comment_site &&
		$rs->comment_email == $rs->user_email &&
		$rs->comment_site == $rs->user_url;
	}
}

class rsExtDates
{
	public static function ts(&$rs)
	{
		return strtotime($rs->dt);
	}
	
	public static function year(&$rs)
	{
		return date('Y',strtotime($rs->dt));
	}
	
	public static function month(&$rs)
	{
		return date('m',strtotime($rs->dt));
	}
	
	public static function day(&$rs)
	{
		return date('d',strtotime($rs->dt));
	}
	
	public static function url(&$rs,&$core)
	{
		$url = date('Y/m',strtotime($rs->dt));
		
		return $core->blog->url.$core->url->getBase('archive').'/'.$url;
	}
	
	public static function yearHeader(&$rs)
	{
		if ($rs->isStart()) {
			return true;
		}
		
		$y = $rs->year();
		$rs->movePrev();
		$py = $rs->year();
		$rs->moveNext();
		
		return $y != $py;
	}
	
	public static function yearFooter(&$rs)
	{
		if ($rs->isEnd()) {
			return true;
		}
		
		$y = $rs->year();
		if ($rs->moveNext()) {
			$ny = $rs->year();
			$rs->movePrev();
			return $y != $ny;
		}
		return false;
		
	}
}

class rsExtUser
{
	public static function option(&$rs,$name)
	{
		$options = self::options($rs);
		
		if (isset($options[$name])) {
			return $options[$name];
		}
		return null;
	}
	
	public static function options(&$rs)
	{
		$options = @unserialize($rs->user_options);
		if (is_array($options)) {
			return $options;
		}
		return array();
	}
}
?>