<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class urlHandler
{
	private $types = array();
	private $default_handler;
	public $mode;
	public $type = 'default';
	
	public function __construct($mode='path_info')
	{
		$this->mode = $mode;
	}
	
	public function register($type,$url,$representation,$handler)
	{
		$this->types[$type] = array(
			'url' => $url,
			'representation' => $representation,
			'handler' => $handler
		);
	}
	
	public function registerDefault($handler)
	{
		$this->default_handler = $handler;
	}
	
	public function unregister($type)
	{
		if (isset($this->types[$type])) {
			unset($this->types[$type]);
		}
	}
	
	public function getBase($type)
	{
		if (isset($this->types[$type])) {
			return $this->types[$type]['url'];
		}
		return null;
	}
	
	public function getDocument()
	{
		$type = $args = '';
		
		if ($this->mode == 'path_info')
		{
			$part = substr($_SERVER['PATH_INFO'],1);
		}
		else
		{
			$part = '';
			
			parse_str($this->rebuildQueryString(),$qs);
			
			$qs = array_keys($qs);
			if (!empty($qs) && $_GET[$qs[0]] == '') {
				$part = $qs[0];
				unset($_GET[$qs[0]]);
				unset($_REQUEST[$qs[0]]);
			}
		}
		
		$_SERVER['DC_REQUEST_PART'] = $part;
		
		$this->getArgs($part,$type,$args);
		
		if (!$type)
		{
			$this->type = 'default';
			$this->callDefaultHandler($args);
		}
		else
		{
			$this->type = $type;
			$this->callHandler($type,$args);
		}
	}
	
	private function getArgs($part,&$type,&$args)
	{
		if ($part == '') {
			$type = null;
			$args = null;
			return;
		}
		
		$this->sortTypes();
		
		foreach ($this->types as $k => $v)
		{
			$repr = $v['representation'];
			if ($repr == $part) {
				$type = $k;
				$args = null;
				return;
			}
			elseif (preg_match('#'.$repr.'#',$part,$m))
			{
				$type = $k;
				$args = isset($m[1]) ? $m[1] : null;
				return;
			}
		}
		
		# No type, pass args to default
		$args = $part;
	}
	
	private function callHandler($type,$args)
	{
		if (!isset($this->types[$type])) {
			throw new Exception('Unknown URL type');
		}
		
		$handler = $this->types[$type]['handler'];
		if (!is_callable($handler)) {
			throw new Exception('Unable to call function');
		}
		
		call_user_func($handler,$args);
	}
	
	private function callDefaultHandler($args)
	{
		if (!is_callable($this->default_handler)) {
			throw new Exception('Unable to call function');
		}
		
		call_user_func($this->default_handler,$args);
	}
	
	private function rebuildQueryString()
	{
		if (!empty($_SERVER['QUERY_STRING']))
		{
			$q = explode('&',$_SERVER['QUERY_STRING']);
			$T = array();
			foreach ($q as $v)
			{
				$t = explode('=',$v);
				if (empty($t[1])) {
					$t[1] = '0';
				}
				$T[] = $t[0].'='.$t[1];
			}
			return implode('&',$T);
		}
		return '';
	}
	
	private function sortTypes()
	{
		foreach ($this->types as $k => $v) {
			$r[$k] = $v['url'];
		}
		array_multisort($r,SORT_DESC,$this->types);
	}
}
?>