function submitPostsForm(F,msg)
{
	// Get all form elements
	var inputs = F.elements;
	var post_ids = new Array();
	var action;
	
	// Get user_ids
	var i = 0;
	for (i=0; i<inputs.length; i++)
	{
		if (inputs[i].name == 'entries[]') {
			post_ids.push(inputs[i]);
		}
		
		if (inputs[i].name == 'action') {
			action = inputs[i].value;
		}
	}
	
	var selectfields = 0;
	for (i=0; i<post_ids.length; i++) {
		selectfields += post_ids[i].checked;
	}
	
	if (selectfields == 0) {
		return false;
	}
	
	if (action == 'delete') {
		return window.confirm(msg);
	}
	
	return true;
}

function postExpander(line)
{
	var td = line.firstChild;
	
	var img = document.createElement('img');
	img.src = 'images/plus.png';
	img.className = 'expand';
	img.line = line;
	img.onclick = function() { viewPostContent(this,this.line); }
	
	td.insertBefore(img,td.firstChild);
}

function viewPostContent(img,line)
{
	var postId = line.id.substr(1);
	
	var tr = document.getElementById('pe'+postId);
	
	if (!tr)
	{
		tr = document.createElement('tr');
		tr.id = 'pe'+postId;
		var td = document.createElement('td');
		td.colSpan = 8;
		td.className = 'expand';
		tr.appendChild(td);
		
		img.src = 'images/minus.png';
		
		// Get post content
		var x = new ajaxTools();
		x.param('f','getPostById');
		x.param('id',postId);
		
		x.callUrl('services.php',
		function() {
			var rsp = this.responseXML.getElementsByTagName('rsp').item(0);
			
			if (rsp.attributes[0].value == 'ok') {
				var post = x.elementContent(rsp.getElementsByTagName('post_display_content').item(0));
				var post_excerpt = x.elementContent(rsp.getElementsByTagName('post_display_excerpt').item(0));
				
				if (post) {
					if (post_excerpt) {
						td.innerHTML += post_excerpt;
						td.innerHTML += '<hr />';
					}
					td.innerHTML += post;
				}
			} else {
				alert(x.elementContent(rsp.getElementsByTagName('message').item(0)));
			}
		});
		
		line.className += ' expand';
		line.parentNode.insertBefore(tr,line.nextSibling);
	}
	else if (tr.style.display == 'none')
	{
		tr.style.display = '';
		line.className += ' expand';
		img.src = 'images/minus.png';
	}
	else
	{
		tr.style.display = 'none';
		line.className = line.className.replace(/ expand$/,'');
		img.src = 'images/plus.png';
	}
}