<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

$standalone = (!ini_get('auto_prepend_file') && count(get_included_files()) == 1)
		|| count(get_included_files()) == 2;

$blog_id = false;

if ($standalone)
{
	require dirname(__FILE__).'/../inc/admin/prepend.php';
	dcPage::check('admin');
	$blog_id = $core->blog->id;
	$blog_url = $core->blog->url;
	$blog_status = $core->blog->status;
	$blog_name = $core->blog->name;
	$blog_desc = $core->blog->desc;
	$blog_settings = $core->blog->settings;
	
	$action = 'blog_pref.php';
	$redir = 'blog_pref.php?upd=1';
}
else
{
	dcPage::checkSuper();
	try
	{
		if (empty($_REQUEST['id'])) {
			throw new Exception(__('No given blog id.'));
		}
		$rs = $core->getBlog($_REQUEST['id']);
		
		if (!$rs) {
			throw new Exception(__('No such blog.'));
		}
		
		$blog_id = $rs->blog_id;
		$blog_url = $rs->blog_url;
		$blog_status = $rs->blog_status;
		$blog_name = $rs->blog_name;
		$blog_desc = $rs->blog_desc;
		$blog_settings = new dcSettings($core,$blog_id);
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
	
	$action = 'blog.php';
	$redir = 'blog.php?id=%s&upd=1';
}

# Language codes
foreach (l10n::getISOcodes(1) as $k => $v) {
	$lang_combo[] = new formSelectOption($k,$v,$v == 'en' || is_dir(DC_L10N_ROOT.'/'.$v) ? 'avail10n' : '');
}

# Update a blog
if ($blog_id && !empty($_POST) && $core->auth->check('admin',$blog_id))
{
	$cur = $core->con->openCursor($core->prefix.'blog');
	if ($core->auth->isSuperAdmin()) {
		$cur->blog_id = $_POST['blog_id'];
		$cur->blog_url = $_POST['blog_url'];
		$cur->blog_status = (integer) $_POST['blog_status'];
	}
	$cur->blog_name = $_POST['blog_name'];
	$cur->blog_desc = $_POST['blog_desc'];
	
	$nb_post_per_page = abs((integer) $_POST['nb_post_per_page']);
	if ($nb_post_per_page <= 1) { $nb_post_per_page = 1; }
	
	try
	{
		$core->updBlog($blog_id,$cur);
		
		if ($blog_id == $core->blog->id && $cur->blog_id != null && $cur->blog_id != $blog_id) {
			$blog_id = $cur->blog_id;
			$core->setBlog($cur->blog_id);
			$_SESSION['sess_blog_id'] = $cur->blog_id;
			$blog_settings = $core->blog->settings;
		}
		
		
		$blog_settings->setNameSpace('system');
		
		$blog_settings->put('editor',$_POST['editor']);
		$blog_settings->put('copyright_notice',$_POST['copyright_notice']);
		$blog_settings->put('lang',$_POST['lang']);
		$blog_settings->put('blog_timezone',$_POST['blog_timezone']);
		$blog_settings->put('date_format',$_POST['date_format']);
		$blog_settings->put('time_format',$_POST['time_format']);
		$blog_settings->put('nb_post_per_page',$nb_post_per_page);
		$blog_settings->put('comments_ttl',abs((integer) $_POST['comments_ttl']));
		$blog_settings->put('use_smilies',!empty($_POST['use_smilies']));
		$blog_settings->put('allow_comments',!empty($_POST['allow_comments']));
		$blog_settings->put('allow_trackbacks',!empty($_POST['allow_trackbacks']));
		$blog_settings->put('comments_pub',empty($_POST['comments_pub']));
		$blog_settings->put('comments_nofollow',!empty($_POST['comments_nofollow']));
		$blog_settings->put('wiki_comments',!empty($_POST['wiki_comments']));
		$blog_settings->put('enable_xmlrpc',!empty($_POST['enable_xmlrpc']));
		
		if ($cur->blog_url !== null) {
			if (substr($cur->blog_url,-1) == '?') {
				$blog_settings->put('url_scan','query_string');
			} else {
				$blog_settings->put('url_scan','path_info');
			}
		}
		
		http::redirect(sprintf($redir,$blog_id));
	}
	catch (Exception $e)
	{
		$core->error->add($e->getMessage());
	}
}

dcPage::open(__('Blog settings'),
	dcPage::jsConfirmClose('blog-form').
	dcPage::jsMultiPartPage()
);

if ($blog_id)
{
	# Status combo
	foreach ($core->getAllBlogStatus() as $k => $v) {
		$status_combo[$v] = (string) $k;
	}
	
	echo '<h2>'.(!$standalone ? '<a href="blogs.php">'.__('Blogs').'</a> &gt; ' : '').
	html::escapeHTML($blog_name).' &gt; '.
	__('Blog settings').'</h2>';
	
	if (!empty($_GET['add'])) {
		echo '<p class="message">'.__('Blog has been successfully created.').'</p>';
	}
	
	if (!empty($_GET['upd'])) {
		echo '<p class="message">'.__('Blog has been successfully updated.').'</p>';
	}
	
	echo
	'<div class="multi-part" id="params" title="'.__('Parameters').'">'.
	'<h3>'.__('Parameters').'</h3>'.
	'<form action="'.$action.'" method="post" id="blog-form">';

	echo
	'<fieldset><legend>'.__('Blog details').'</legend>';
	
	if ($core->auth->isSuperAdmin())
	{
		echo
		'<p><label class="required" title="'.__('Required field').'">'.__('Blog ID:').
		dcPage::help('blog_pref','p_blogid').
		form::field('blog_id',30,32,html::escapeHTML($blog_id)).'</label></p>'.
		'<p class="form-note">'.__('At least 2 characters using letters, numbers or symbols.').'</p>';
	}
	
	echo
	'<p><label class="required" title="'.__('Required field').'">'.__('Blog name:').
	dcPage::help('blog_pref','p_name').
	form::field('blog_name',30,255,html::escapeHTML($blog_name)).'</label></p>';
	
	if ($core->auth->isSuperAdmin())
	{
		echo
		'<p><label class="required" title="'.__('Required field').'">'.__('Blog URL:').
		dcPage::help('blog_pref','p_url').
		form::field('blog_url',30,255,html::escapeHTML($blog_url)).'</label></p>'.
		
		'<p><label>'.__('Blog status:').
		dcPage::help('blog_pref','p_status').
		form::combo('blog_status',$status_combo,$blog_status).'</label></p>';
	}
	
	echo
	'<p class="area"><label for="blog_desc">'.__('Blog description:').
	dcPage::help('blog_pref','p_desc').'</label>'.
	form::textarea('blog_desc',60,5,html::escapeHTML($blog_desc)).'</p>'.
	'</fieldset>';


	echo
	'<fieldset><legend>'.__('Blog configuration').'</legend>'.
	'<div class="two-cols">'.
	'<div class="col">'.
	'<p><label>'.__('Blog editor name:').
	dcPage::help('blog_pref','p_editor').
	form::field('editor',30,255,html::escapeHTML($blog_settings->editor)).
	'</label></p>'.
	
	'<p><label>'.__('Copyright notice:').
	dcPage::help('blog_pref','p_copyright').
	form::field('copyright_notice',30,255,html::escapeHTML($blog_settings->copyright_notice)).
	'</label></p>'.
	
	'<p><label>'.__('Default language:').
	dcPage::help('blog_pref','p_lang').
	form::combo('lang',$lang_combo,$blog_settings->lang,'l10n').
	'</label></p>'.
	
	'<p><label>'.__('Blog timezone:').
	dcPage::help('blog_pref','p_tz').
	form::combo('blog_timezone',dt::getZones(true,true),html::escapeHTML($blog_settings->blog_timezone)).
	'</label></p>'.
	
	'<p><label>'.__('Date format:').
	dcPage::help('blog_pref','p_dateformat').
	form::field('date_format',30,255,html::escapeHTML($blog_settings->date_format)).
	'</label></p>'.
	
	'<p><label>'.__('Time format:').
	dcPage::help('blog_pref','p_timeformat').
	form::field('time_format',30,255,html::escapeHTML($blog_settings->time_format)).
	'</label></p>'.
	'</div>'.
	
	'<div class="col">'.
	'<p><label class="classic">'.sprintf(__('Display %s entries per page'),
	form::field('nb_post_per_page',2,3,$blog_settings->nb_post_per_page)).
	dcPage::help('blog_pref','p_nbperpage').
	'</label></p>'.
	
	'<p><label class="classic">'.sprintf(__('Leave comments open during %s days'),
	form::field('comments_ttl',2,3,$blog_settings->comments_ttl)).
	dcPage::help('blog_pref','p_comment_ttl').
	'</label></p>'.
	'<p class="form-note">'.__('Leave empty to cancel this feature.').'</p>'.
	
	'<p><label class="classic">'.
	form::checkbox('use_smilies','1',$blog_settings->use_smilies).
	__('Display smilies on entries and comments').
	dcPage::help('blog_pref','p_smilies').'</label></p>'.
	
	'<p><label class="classic">'.
	form::checkbox('allow_comments','1',$blog_settings->allow_comments).
	__('Accept comments').dcPage::help('blog_pref','p_comments').'</label></p>'.
	
	'<p><label class="classic">'.
	form::checkbox('allow_trackbacks','1',$blog_settings->allow_trackbacks).
	__('Accept trackbacks').
	dcPage::help('blog_pref','p_trackbacks').'</label></p>'.
	
	'<p><label class="classic">'.
	form::checkbox('comments_pub','1',!$blog_settings->comments_pub).
	__('Moderate comments and trackbacks').
	dcPage::help('blog_pref','p_comments_pub').'</label></p>'.
	
	'<p><label class="classic">'.
	form::checkbox('comments_nofollow','1',$blog_settings->comments_nofollow).
	__('Add "nofollow" relation on comments and trackbacks links').
	dcPage::help('blog_pref','p_nofollow').'</label></p>'.
	
	'<p><label class="classic">'.
	form::checkbox('wiki_comments','1',$blog_settings->wiki_comments).
	__('Wiki syntax for comments').
	dcPage::help('blog_pref','p_wiki_comments').'</label></p>'.
	
	'<p><label class="classic">'.
	form::checkbox('enable_xmlrpc','1',$blog_settings->enable_xmlrpc).
	__('Enable XML/RPC interface').'</label>'.
	' - <a href="#xmlrpc">'.__('more information').'</a></p>'.
	'</div>'.
	'</div>'.
	'<br class="clear" />'. //Opera sucks
	'</fieldset>';

	echo
	'<p><input type="submit" value="'.__('save').'" />'.
	(!$standalone ? form::hidden('id',$blog_id) : '').
	'</p>'.
	'</form>';
	
	if ($core->auth->isSuperAdmin() && $blog_id != $core->blog->id)
	{
		echo
		'<form action="blog_del.php" method="post">'.
		'<p><input type="submit" value="'.__('Delete this blog').'" />'.
		form::hidden(array('blog_id'),$blog_id).'</p>'.
		'</form>';
	}
	
	# XML/RPC information
	echo '<h3 id="xmlrpc">'.__('XML/RPC interface').'</h3>';
	
	echo '<p>'.__('XML/RPC interface allows you to edit your blog with an external client.').'</p>';
	
	if (!$blog_settings->enable_xmlrpc)
	{
		echo '<p>'.__('XML/RPC interface is not active. Change settings to enable it.').'</p>';
	}
	else
	{
		echo
		'<p>'.__('XML/RPC inteface is active. You should set the following parameters on your XML/RPC client:').'</p>'.
		'<ul>'.
		'<li>'.__('Server URL:').' <strong>'.
		http::concatURL(dirname(http::getSelfURI()).'/','xmlrpc.php').'?b='.rawurlencode($blog_id).'</strong></li>'.
		'<li>'.__('Blogging system:').' <strong>Movable Type</strong></li>'.
		'<li>'.__('User name:').' <strong>'.$core->auth->userID().'</strong></li>'.
		'<li>'.__('Password:').' <strong>'.__('your password').'</strong></li>'.
		'<li>'.__('Blog ID:').' <strong>1</strong></li>'.
		'</ul>';
	}
	
	echo '</div>';
	
	#
	# Users on the blog (with permissions)
	
	$blog_users = $core->getBlogPermissions($blog_id,$core->auth->isSuperAdmin());
	$perm_types = $core->auth->getPermissionsTypes();
	
	echo
	'<div class="multi-part" id="users" title="'.__('Users').'">'.
	'<h3>'.__('Users on this blog').'</h3>';
	
	if (empty($blog_users))
	{
		echo '<p>'.__('No users').'</p>';
	}
	else
	{
		if ($core->auth->isSuperAdmin()) {
			$user_url_p = '<a href="user.php?id=%1$s">%1$s</a>';
		} else {
			$user_url_p = '%1$s';
		}
		
		foreach ($blog_users as $k => $v)
		{
			if (count($v['p']) > 0)
			{
				echo
				'<h4>'.sprintf($user_url_p,html::escapeHTML($k)).
				' ('.html::escapeHTML(dcUtils::getUserCN(
					$k, $v['name'], $v['firstname'], $v['displayname']
				)).')';
				
				if (!$v['super'] && $core->auth->isSuperAdmin()) {
					echo
					' - <a href="permissions.php?blog_id[]='.$blog_id.'&amp;user_id[]='.$k.'">'
					.__('change permissions').'</a>';
				}
				
				echo '</h4>';
				
				echo '<ul>';
				if ($v['super']) {
					echo '<li>'.__('Super administrator').'</li>';
				} else {
					foreach ($v['p'] as $p => $V) {
						echo '<li>'.__($perm_types[$p]).'</li>';
					}
				}
				echo '</ul>';
			}
		}
	}
	
	echo '</div>';
	
	
}

dcPage::close();
?>