<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2005 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****
if (!defined('DC_CONTEXT_ADMIN')) { exit; }

require dirname(__FILE__).'/class.widgets.php';

$widgets = new dcWidgets;

try {
	require dirname(__FILE__).'/_default_widgets.php';
	
	# --BEHAVIOR-- adminInitWidgets
	$core->callBehavior('adminInitWidgets',$widgets);
} catch (Exception $e) {
	$core->error->add($e->getMessage());
}

# Loading navigation and extra widgets
$widgets_nav = dcWidgets::load($core->blog->settings->widgets_nav);
$widgets_extra = dcWidgets::load($core->blog->settings->widgets_extra);

$append_combo = array(
	'-' => 0,
	__('navigation') => 'nav',
	__('extra') => 'extra'
);

# Adding widgets to sidebars
if (!empty($_POST['append']) && is_array($_POST['addw']))
{
	# Filter selection
	$addw = array();
	foreach ($_POST['addw'] as $k => $v) {
		if (($v == 'extra' || $v == 'nav') && $widgets->{$k} !== null ) {
			$addw[$k] = $v;
		}
	}
	
	# Append widgets
	if (!empty($addw))
	{
		foreach ($addw as $k => $v)
		{
			switch ($v) {
				case 'nav':
					$widgets_nav->append($widgets->{$k});
					break;
				case 'extra':
					$widgets_extra->append($widgets->{$k});
					break;
				
			}
		}
		
		try {
			$core->blog->settings->setNameSpace('widgets');
			$core->blog->settings->put('widgets_nav',$widgets_nav->store());
			$core->blog->settings->put('widgets_extra',$widgets_extra->store());
			$core->blog->triggerBlog();
			http::redirect($p_url);
		} catch (Exception $e) {
			$core->error->add($e->getMessage());
		}
	}
}

# Update sidebars
if (!empty($_POST['wup']))
{
	if (!isset($_POST['w']) || !is_array($_POST['w'])) {
		$_POST['w'] = array();
	}
	
	try
	{
		# Removing mark as _rem widgets
		foreach ($_POST['w'] as $nsid => $nsw) {
			foreach ($nsw as $i => $v) {
				if (!empty($v['_rem'])) {
					unset($_POST['w'][$nsid][$i]);
					continue;
				}
			}
		}
		
		
		$widgets_nav = dcWidgets::loadArray($_POST['w']['nav'],$widgets);
		$widgets_extra = dcWidgets::loadArray($_POST['w']['extra'],$widgets);
		
		$core->blog->settings->setNameSpace('widgets');
		$core->blog->settings->put('widgets_nav',$widgets_nav->store());
		$core->blog->settings->put('widgets_extra',$widgets_extra->store());
		$core->blog->triggerBlog();
		http::redirect($p_url);
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}

$empty_msg = __('Sidebar is not yet customized. It containts the following default widgets: %s.');
$default_nav_msg = sprintf($empty_msg,__('Search, Navigation Links, Selected entries, Categories'));
$default_extra_msg = sprintf($empty_msg,__('Subscribe links'));
?>
<html>
<head>
  <title><?php echo __('Widgets'); ?></title>
  <style type="text/css">
  <?php echo file_get_contents(dirname(__FILE__).'/style.css'); ?>
  </style>
  <script type="text/javascript" src="js/tool-man/core.js"></script>
  <script type="text/javascript" src="js/tool-man/events.js"></script>
  <script type="text/javascript" src="js/tool-man/css.js"></script>
  <script type="text/javascript" src="js/tool-man/coordinates.js"></script>
  <script type="text/javascript" src="js/tool-man/drag.js"></script>
  <script type="text/javascript" src="index.php?pf=widgets/dragdrop.js"></script>
  <script type="text/javascript" src="index.php?pf=widgets/widgets.js"></script>
</head>
<body>
<?php
echo '<h2>'.html::escapeHTML($core->blog->name).' &gt; '.__('Widgets').'</h2>';

# All widgets
echo
'<form id="listWidgets" action="'.$p_url.'" method="post"  class="widgets">'.
'<fieldset><legend>'.__('Available widgets').'</legend>'.
'<div id="widgets">';

foreach ($widgets->elements() as $w) {
	echo
	'<div>'.form::hidden(array('w[void][0][id]'),html::escapeHTML($w->id())).
	'<h4>'.form::field(array('w[void][0][order]'),2,3,0,'hideControl').' '.
	$w->name().'</h4>'.
	'<p class="js-remove"><label class="classic">'.__('Append to:').' '.
	form::combo(array('addw['.$w->id().']'),$append_combo).'</label></p>'.
	'<div class="widgetSettings">'.$w->formSettings('w[void][0]').'</div>'.
	'</div>';
}

echo
'</div>'.
'</fieldset>'.
'<p><input type="submit" class="js-remove" name="append" value="'.__('add widgets to sidebars').'" /></p>'.
'</form>';

echo '<form id="sidebarsWidgets" action="'.$p_url.'" method="post">';
# Nav sidebar
echo
'<div id="sidebarNav" class="widgets">'.
sidebarWidgets('dndnav',__('Navigation sidebar'),$widgets_nav,'nav',$default_nav_msg).
'</div>';

# Extra sidebar
echo
'<div id="sidebarExtra" class="widgets">'.
sidebarWidgets('dndextra',__('Extra sidebar'),$widgets_extra,'extra',$default_extra_msg).
'</div>';

echo
'<p id="sidebarsControl">'.
'<input type="submit" name="wup" value="'.__('update sidebars').'" /></p>'.
'</form>';

function sidebarWidgets($id,$title,&$widgets,$pr,$default_msg)
{
	$res = '<fieldset><legend>'.$title.'</legend><div id="'.$id.'">';
	
	if ($widgets->isEmpty()) {
		$res .= '<p class="empty-widgets">'.$default_msg.'</p>';
	}
	
	$i = 0;
	foreach ($widgets->elements() as $w)
	{
		$iname = 'w['.$pr.']['.$i.']';
		
		$res .=
		'<div>'.form::hidden(array($iname.'[id]'),html::escapeHTML($w->id())).
		'<h4>'.form::field(array($iname.'[order]'),2,3,(string) $i,'js-hide','',0,'title="'.__('order').'"').' '.
		$w->name().'</h4>'.
		'<p class="removeWidget js-remove"><label class="classic">'.
		form::checkbox(array($iname.'[_rem]'),'1',0).' '.__('Remove widget').
		'</label></p>'.
		'<div class="widgetSettings">'.$w->formSettings($iname).'</div>'.
		'</div>';
		
		$i++;
	}
	$res .= '</div></fieldset>';
	
	return $res;
}
?>
</body>
</html>