<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2006 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ***** END LICENSE BLOCK *****

class linksImporter
{
	protected $entries = null;
		
	public function parse($data)
	{
		if (preg_match('!<xbel\s+version!', $data)) {
			$this->_parseXBEL($data);
		}
		elseif (preg_match('!<opml\s+version!', $data)) {
			$this->_parseOPML($data);
		}
		else {
			throw new Exception(__('You need to provide a XBEL or OPML file.'));
		}
	}
	
	
	protected function _parseOPML($data)
	{
		$xml = @simplexml_load_string($data);
		if (!$xml) throw new Exception(__('File is not in XML format.'));
		
		$outlines = $xml->xpath("//outline");
		
		$this->entries = array();
		foreach ($outlines as $outline) {
			if (!isset($outline['htmlUrl'])) continue;
			$entry = new StdClass();
			$entry->link = $outline['htmlUrl'];
			$entry->title = (!empty($outline['title']))?$outline['title']:'';
			if (empty($entry->title)) {
				$entry->title = (!empty($outline['text']))?$outline['text']:$entry->link;
			}
			$entry->desc = (!empty($outline['description']))?$outline['description']:'';
			$this->entries[] = $entry;
		}
	}
	

	protected function _parseXBEL($data)
	{
		$xml = @simplexml_load_string($data);
		if (!$xml) throw new Exception(__('File is not in XML format.'));
		
		$outlines = $xml->xpath("//bookmark");
		
		$this->entries = array();
		foreach ($outlines as $outline) {
			if (!isset($outline['href'])) continue;
			$entry = new StdClass();
			$entry->link = $outline['href'];
			$entry->title = (!empty($outline->title))?$outline->title:'';
			if (empty($entry->title)) {
				$entry->title = $entry->link;
			}
			$entry->desc = (!empty($outline->desc))?$outline->desc:'';
			$this->entries[] = $entry;
		}
	}
	
	
	public function getAll()
	{
		if (!$this->entries) return null;
		return $this->entries;
	}
		
}

class dcImportBlogroll {
	
	public static function loadFile($file)
	{
		if (file_exists($file) && is_readable($file)) {
			$importer = new linksImporter();
			$importer->parse(file_get_contents($file));		
			return $importer->getAll();
		}
		return false;
	}
}
?>